/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.container;

import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerParameter;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianMavenCoordinates;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianContainerModel;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.Converter;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArquillianContainer {
    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract Scope getScope();

    @NotNull
    public abstract Icon getIcon();

    @Nullable
    public abstract String getDescriptionUri();

    @NotNull
    public abstract ArquillianContainerState createDefaultState(Project var1, String var2);

    @NotNull
    public abstract List<ArquillianMavenCoordinates> getDependencies();

    public abstract List<ArquillianContainerParameter> getParameters();

    public abstract JPanel createSettingsPanel(Project var1, ArquillianContainerModel var2);

    public abstract boolean canChangeDependencyList();

    class ScopeConverter
    extends Converter<Scope> {
        ScopeConverter() {
        }

        @Nullable
        public Scope fromString(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainer$ScopeConverter", "fromString"));
            }
            return Scope.fromString(value);
        }

        @NotNull
        public String toString(@NotNull Scope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainer$ScopeConverter", "toString"));
            }
            String string = scope.getDescription();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainer$ScopeConverter", "toString"));
            }
            return string;
        }
    }

    public static enum Scope implements Comparable<Scope>
    {
        Manual(ArquillianBundle.message("arquillian.manual.configuration.name", new Object[0]), 1000),
        Embedded(ArquillianBundle.message("arquillian.embedded.configuration.name", new Object[0]), 2000),
        Managed(ArquillianBundle.message("arquillian.managed.configuration.name", new Object[0]), 3000),
        Remote(ArquillianBundle.message("arquillian.remote.configuration.name", new Object[0]), 4000);

        private static Map<String, Scope> values;
        private final String description;
        private final int weight;

        private Scope(String description, int weight) {
            this.description = description;
            this.weight = weight;
        }

        public static Scope fromString(String strScope) {
            Scope scope = values.get(strScope);
            return scope == null ? Manual : scope;
        }

        public String getDescription() {
            return this.description;
        }

        public int getWeight() {
            return this.weight;
        }

        static {
            values = new HashMap();
            for (Scope scope : Scope.values()) {
                values.put(scope.getDescription(), scope);
            }
        }
    }
}

