/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.ArquillianContainersAppManager;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainer;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianContainerModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianContainersModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianListModel;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersManager;
import com.intellij.plugins.jboss.arquillian.configuration.ui.ItemNode;
import com.intellij.plugins.jboss.arquillian.configuration.ui.ScopeNode;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterable;
import icons.ArquillianIcons;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianSettingsConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    private static final String ARQUILLIAN_CONTAINERS_UI_KEY = "ArquillianSettingsConfigurable.UI";
    private final ArquillianContainersAppManager appManager;
    private final ArquillianContainersManager containersManager;
    private final Project project;
    private final ArquillianContainersModel model;
    private final List<ScopeNode> scopeNodes = new ArrayList<ScopeNode>();
    private final Map<ArquillianContainer.Scope, ScopeNode> scopeToNodesMap = new HashMap<ArquillianContainer.Scope, ScopeNode>();
    private final Map<ArquillianContainerModel, ItemNode> modelToItemMap = new HashMap<ArquillianContainerModel, ItemNode>();

    public ArquillianSettingsConfigurable(ArquillianContainersAppManager appManager, ArquillianContainersManager containersManager, Project project) {
        this.appManager = appManager;
        this.containersManager = containersManager;
        this.project = project;
        this.model = new ArquillianContainersModel(project, containersManager.getState());
        for (ArquillianContainer.Scope scope : ArquillianContainer.Scope.values()) {
            ScopeNode scopeNode = new ScopeNode(scope);
            this.scopeToNodesMap.put(scope, scopeNode);
            this.scopeNodes.add(scopeNode);
        }
        this.initTree();
        this.model.getListListenersHolder().addListener(new ArquillianListModel.Listener<ArquillianContainerState, ArquillianContainerModel>(){

            @Override
            public void itemChanged(ArquillianContainerModel model) {
                ItemNode itemNode = (ItemNode)((Object)ArquillianSettingsConfigurable.this.modelToItemMap.get(model));
                ((DefaultTreeModel)ArquillianSettingsConfigurable.this.myTree.getModel()).nodeChanged((TreeNode)((Object)itemNode));
            }

            @Override
            public void itemAdded(ArquillianContainerModel item, int index) {
                ArquillianSettingsConfigurable.this.addItemNode(item);
            }

            @Override
            public void itemRemoved(ArquillianContainerModel item, int index) {
                ArquillianSettingsConfigurable.this.removeItemNode(item);
            }
        });
    }

    private static DefaultMutableTreeNode getNodeToSelectWhenDeleted(ItemNode itemNode) {
        return itemNode.getNextNode() != null ? itemNode.getNextNode() : (itemNode.getPreviousNode() != null ? itemNode.getPreviousNode() : (itemNode.getNextLeaf() != null ? itemNode.getNextLeaf() : itemNode.getPreviousLeaf()));
    }

    private int getScopeNodeVisibleIndex(ScopeNode scopeNode) {
        int index = 0;
        for (ScopeNode node : this.scopeNodes) {
            if (node == scopeNode) break;
            if (!node.isVisible()) continue;
            ++index;
        }
        return index;
    }

    private void showScopeNode(ScopeNode scopeNode) {
        if (scopeNode.isVisible()) {
            return;
        }
        int index = this.getScopeNodeVisibleIndex(scopeNode);
        this.myRoot.insert((MutableTreeNode)((Object)scopeNode), index);
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted((TreeNode)this.myRoot, new int[]{index});
        scopeNode.setVisible(true);
    }

    private void hideScopeNode(ScopeNode scopeNode) {
        if (!scopeNode.isVisible()) {
            return;
        }
        int index = this.getScopeNodeVisibleIndex(scopeNode);
        this.myRoot.remove(index);
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereRemoved((TreeNode)this.myRoot, new int[]{index}, (Object[])new ScopeNode[]{scopeNode});
        scopeNode.setVisible(false);
    }

    private void addItemNode(ArquillianContainerModel item) {
        ScopeNode scopeNode = this.scopeToNodesMap.get(item.getDescription().getScope());
        int scopeNodeChildrenCount = scopeNode.getChildCount();
        if (scopeNodeChildrenCount == 0) {
            this.showScopeNode(scopeNode);
        }
        ItemNode itemNode = new ItemNode(this.project, item, this.TREE_UPDATER);
        scopeNode.add((MutableTreeNode)((Object)itemNode));
        this.modelToItemMap.put(item, itemNode);
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted((TreeNode)((Object)scopeNode), new int[]{scopeNode.getChildCount() - 1});
    }

    private void removeItemNode(ArquillianContainerModel item) {
        ScopeNode scopeNode = this.scopeToNodesMap.get(item.getDescription().getScope());
        ItemNode itemNode = this.modelToItemMap.remove(item);
        DefaultMutableTreeNode nodeToSelect = ArquillianSettingsConfigurable.getNodeToSelectWhenDeleted(itemNode);
        if (nodeToSelect == null) {
            nodeToSelect = itemNode.getPreviousNode();
        }
        int itemNodeIndex = scopeNode.getIndex((TreeNode)((Object)itemNode));
        scopeNode.remove((MutableTreeNode)((Object)itemNode));
        if (scopeNode.getChildCount() == 0) {
            this.hideScopeNode(scopeNode);
        } else {
            ((DefaultTreeModel)this.myTree.getModel()).nodesWereRemoved((TreeNode)((Object)scopeNode), new int[]{itemNodeIndex}, (Object[])new ItemNode[]{itemNode});
        }
        this.selectNodeInTree(nodeToSelect);
    }

    protected void initTree() {
        ArrayList modelItems = new ArrayList(this.model.getChildren());
        Collections.sort(modelItems, new ArquillianContainerModel.ScopeNameComparator());
        for (ArquillianContainerModel containerModel : modelItems) {
            this.addItemNode(containerModel);
        }
        super.initTree();
        this.myTree.setShowsRootHandles(false);
        new TreeSpeedSearch(this.myTree, treePath -> {
            MasterDetailsComponent.MyNode lastPathComponent = (MasterDetailsComponent.MyNode)treePath.getLastPathComponent();
            return lastPathComponent.getChildCount() > 0 ? "" : lastPathComponent.getDisplayName();
        }, true);
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add(new AddAction());
        result.add((AnAction)new RemoveAction());
        result.add(new CloneAction());
        return result;
    }

    public boolean isModified() {
        return this.containersManager.hasChanges(this.model);
    }

    public void apply() throws ConfigurationException {
        this.checkNoDuplicates();
        this.containersManager.saveContainersModel(this.model);
    }

    private void checkNoDuplicates() throws ConfigurationException {
        HashSet names = new HashSet();
        for (ArquillianContainerModel containerModel : this.model.getChildren()) {
            if (names.contains(containerModel.getName())) {
                throw new ConfigurationException(ArquillianBundle.message("arquillian.container.name.already.exist", containerModel.getName()));
            }
            names.add(containerModel.getName());
        }
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    protected String getComponentStateKey() {
        return ARQUILLIAN_CONTAINERS_UI_KEY;
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.project);
    }

    private void createNewConfiguration(ArquillianContainer container) {
        String name = this.model.selectUnusedName(container.getName());
        ArquillianContainerModel containerModel = new ArquillianContainerModel(this.project, name, container);
        this.model.addItem(containerModel);
        this.selectNodeInTree((DefaultMutableTreeNode)((Object)this.modelToItemMap.get(containerModel)));
    }

    private void removeConfiguration(ItemNode itemNode) {
        this.model.removeItem(itemNode.getModel());
    }

    @NotNull
    public String getId() {
        if ("arq.settings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianSettingsConfigurable", "getId"));
        }
        return "arq.settings";
    }

    @Nls
    public String getDisplayName() {
        return ArquillianBundle.message("arquillian.containers.configurable.display.name", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.arquillian.containers";
    }

    private void cloneConfiguration(ItemNode itemNode) {
        ArquillianContainerModel model = this.model.cloneConfiguration(itemNode.getModel());
        this.selectNodeInTree((DefaultMutableTreeNode)((Object)this.modelToItemMap.get(model)));
    }

    private void showAddPopup() {
        List groups = JBIterable.of((Object[])ArquillianContainer.Scope.values()).filter(scope -> this.appManager.getContainers((ArquillianContainer.Scope)scope).size() > 0).toList();
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ArquillianContainer.Scope>("Select Container Configuration", groups){

            @NotNull
            public String getTextFor(ArquillianContainer.Scope scope) {
                String string = this.hasSubstep(scope) ? scope.getDescription() : ArquillianSettingsConfigurable.this.appManager.getContainers(scope).get(0).getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianSettingsConfigurable$2", "getTextFor"));
                }
                return string;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public boolean canBeHidden(ArquillianContainer.Scope scope) {
                return false;
            }

            public Icon getIconFor(ArquillianContainer.Scope scope) {
                return this.hasSubstep(scope) ? ArquillianIcons.Arquillian : ArquillianSettingsConfigurable.this.appManager.getContainers(scope).get(0).getIcon();
            }

            public PopupStep onChosen(ArquillianContainer.Scope scope, boolean finalChoice) {
                if (this.hasSubstep(scope)) {
                    return this.getSupStep(scope);
                }
                ArquillianSettingsConfigurable.this.createNewConfiguration(ArquillianSettingsConfigurable.this.appManager.getContainers(scope).get(0));
                return FINAL_CHOICE;
            }

            private ListPopupStep getSupStep(ArquillianContainer.Scope scope) {
                return new BaseListPopupStep<ArquillianContainer>(scope.getDescription(), ArquillianSettingsConfigurable.this.appManager.getContainers(scope)){

                    @NotNull
                    public String getTextFor(ArquillianContainer container) {
                        String string = container.getName();
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianSettingsConfigurable$2$1", "getTextFor"));
                        }
                        return string;
                    }

                    public Icon getIconFor(ArquillianContainer container) {
                        return container.getIcon();
                    }

                    public PopupStep onChosen(ArquillianContainer container, boolean finalChoice) {
                        ArquillianSettingsConfigurable.this.createNewConfiguration(container);
                        return FINAL_CHOICE;
                    }
                };
            }

            public boolean hasSubstep(ArquillianContainer.Scope scope) {
                return ArquillianSettingsConfigurable.this.appManager.getContainers(scope).size() > 1;
            }
        });
        new TreeSpeedSearch((JTree)this.getTree());
        popup.show(new RelativePoint((Component)this.myTree, new Point(0, 0)));
    }

    private class CloneAction
    extends AnAction
    implements AnActionButtonRunnable {
        public CloneAction() {
            super("Clone Container Configuration", "Clone Container Configuration as Manual", AllIcons.Actions.Copy);
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(this.isEnabled(presentation));
        }

        private boolean isEnabled(Presentation presentation) {
            TreePath[] selectionPath = ArquillianSettingsConfigurable.this.myTree.getSelectionPaths();
            if (selectionPath == null || selectionPath.length != 1) {
                return false;
            }
            return selectionPath[0].getLastPathComponent() instanceof ItemNode;
        }

        public void actionPerformed(AnActionEvent e) {
            this.cloneSelectedConfiguration();
        }

        public void run(AnActionButton button) {
            this.cloneSelectedConfiguration();
        }

        private void cloneSelectedConfiguration() {
            TreePath[] selectionPath = ArquillianSettingsConfigurable.this.myTree.getSelectionPaths();
            if (selectionPath == null || selectionPath.length != 1 || !(selectionPath[0].getLastPathComponent() instanceof ItemNode)) {
                return;
            }
            ArquillianSettingsConfigurable.this.cloneConfiguration((ItemNode)((Object)selectionPath[0].getLastPathComponent()));
        }
    }

    private class AddAction
    extends AnAction
    implements AnActionButtonRunnable {
        public AddAction() {
            super("Add New Container Configuration", "Add New Container Configuration", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)ArquillianSettingsConfigurable.this.myTree);
        }

        public void actionPerformed(AnActionEvent e) {
            ArquillianSettingsConfigurable.this.showAddPopup();
        }

        public void run(AnActionButton button) {
            ArquillianSettingsConfigurable.this.showAddPopup();
        }
    }

    private class RemoveAction
    extends MasterDetailsComponent.MyDeleteAction {
        public RemoveAction() {
            super((MasterDetailsComponent)ArquillianSettingsConfigurable.this, ArquillianSettingsConfigurable.forAll((Condition)o -> o instanceof ItemNode));
        }

        public void actionPerformed(AnActionEvent e) {
            TreePath[] paths = ArquillianSettingsConfigurable.this.myTree.getSelectionPaths();
            if (paths != null) {
                for (TreePath path : paths) {
                    Object lastPathComponent = path.getLastPathComponent();
                    if (!(lastPathComponent instanceof ItemNode)) continue;
                    ArquillianSettingsConfigurable.this.removeConfiguration((ItemNode)((Object)lastPathComponent));
                }
            }
        }
    }
}

