/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.TraitInjectorService;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class Grails3TraitInjectorContributor
implements AstTransformationSupport {
    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/lang/Grails3TraitInjectorContributor", "applyTransformation"));
        }
        GrTypeDefinition clazz = context.getCodeClass();
        Collection<String> injectedTraitsFQNs = TraitInjectorService.getInjectedTraits(clazz);
        if (injectedTraitsFQNs.isEmpty()) {
            return;
        }
        Grails3TraitInjectorContributor.injectTraits(clazz, context, injectedTraitsFQNs);
    }

    static void injectTraits(GrTypeDefinition clazz, TransformationContext context, Collection<String> injectedTraitsFQNs) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)clazz.getProject());
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)clazz.getProject());
        PsiClassType currentClassType = elementFactory.createType((PsiClass)clazz);
        for (String fqn : injectedTraitsFQNs) {
            PsiClass traitClass = psiFacade.findClass(fqn, clazz.getResolveScope());
            if (traitClass == null) continue;
            Object[] traitTypeParameters = traitClass.getTypeParameters();
            PsiType[] types = traitTypeParameters.length == 0 ? PsiType.EMPTY_ARRAY : (PsiType[])ContainerUtil.map2Array((Object[])traitTypeParameters, PsiType.class, typeParameter -> currentClassType);
            context.addInterface(elementFactory.createType(traitClass, types));
        }
    }
}

