/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.GspDirectiveKind;
import org.jetbrains.plugins.grails.lang.gsp.parsing.gsp.GspParserDefinition;
import org.jetbrains.plugins.grails.lang.gsp.psi.GspPsiElementFactory;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspScriptletTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.directive.GspDirective;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspXmlRootTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.html.impl.GspHtmlFileImpl;
import org.jetbrains.plugins.grails.lang.gsp.util.GspUtil;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class GspFileImpl
extends PsiFileImpl
implements GspFile {
    private Map<GspDirectiveKind, List<GspDirective>> myDirectives;
    private volatile Map<String, String> myImportedClassesNames;
    private List<String> myImportedPackagesNames;
    private Map<String, Couple<String>> myStaticImportedElements;
    private List<String> myStaticImportedClasses;
    private volatile List<XmlTag> myJsTagCache;

    public GspFileImpl(FileViewProvider viewProvider) {
        super((IElementType)GspParserDefinition.GSP_FILE, (IElementType)GspParserDefinition.GSP_FILE, viewProvider);
    }

    public String toString() {
        return "Groovy Server Pages file";
    }

    @Override
    public GroovyFileBase getGroovyLanguageRoot() {
        PsiFile psiFile = this.getViewProvider().getPsi((Language)GroovyLanguage.INSTANCE);
        return (GroovyFileBase)psiFile;
    }

    private void ensureInitImportCaches() {
        if (this.myImportedClassesNames == null) {
            HashMap<String, String> importedClassesNames = null;
            ArrayList<String> importedPackage = null;
            ArrayList<String> staticImportedClasses = null;
            HashMap<String, Couple> staticImportedElements = null;
            for (GspDirective directive : this.getDirectiveTags(GspDirectiveKind.PAGE, true)) {
                String value;
                XmlAttribute attribute = directive.getAttribute("import");
                if (attribute == null || (value = attribute.getValue()) == null) continue;
                StringTokenizer st = new StringTokenizer(value, ";");
                while (st.hasMoreTokens()) {
                    String name;
                    String str = st.nextToken().trim();
                    Matcher matcher = GspUtil.GSP_IMPORT_PATTERN.matcher(str);
                    if (!matcher.matches()) continue;
                    if (matcher.group(1) != null) {
                        String className;
                        if (matcher.group(6) != null) {
                            if (staticImportedClasses == null) {
                                staticImportedClasses = new ArrayList<String>();
                            }
                            staticImportedClasses.add(matcher.group(2));
                            continue;
                        }
                        if (staticImportedElements == null) {
                            staticImportedElements = new HashMap<String, Couple>();
                        }
                        if ((name = matcher.group(5)) == null) {
                            name = matcher.group(4);
                        }
                        if ((className = matcher.group(3)).length() <= 0) continue;
                        className = className.substring(0, className.length() - 1);
                        String elementName = matcher.group(4);
                        staticImportedElements.put(name, Couple.of((Object)className, (Object)elementName));
                        continue;
                    }
                    if (matcher.group(6) != null) {
                        if (importedPackage == null) {
                            importedPackage = new ArrayList<String>();
                        }
                        importedPackage.add(matcher.group(2));
                        continue;
                    }
                    name = matcher.group(5);
                    if (name == null) {
                        name = matcher.group(4);
                    }
                    if (importedClassesNames == null) {
                        importedClassesNames = new HashMap<String, String>();
                    }
                    importedClassesNames.put(name, matcher.group(2));
                }
            }
            this.myStaticImportedClasses = staticImportedClasses == null ? Collections.emptyList() : staticImportedClasses;
            this.myStaticImportedElements = staticImportedElements == null ? Collections.emptyMap() : staticImportedElements;
            this.myImportedPackagesNames = importedPackage == null ? Collections.emptyList() : importedPackage;
            this.myImportedClassesNames = importedClassesNames == null ? Collections.emptyMap() : importedClassesNames;
        }
    }

    @Override
    @NotNull
    public Map<String, String> getImportedClassesNames() {
        this.ensureInitImportCaches();
        Map<String, String> map2 = this.myImportedClassesNames;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "getImportedClassesNames"));
        }
        return map2;
    }

    @Override
    @NotNull
    public List<String> getImportedPackagesNames() {
        this.ensureInitImportCaches();
        List<String> list = this.myImportedPackagesNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "getImportedPackagesNames"));
        }
        return list;
    }

    @Override
    public Map<String, Couple<String>> getStaticImportedElements() {
        this.ensureInitImportCaches();
        return this.myStaticImportedElements;
    }

    @Override
    public List<String> getStaticImportedClasses() {
        this.ensureInitImportCaches();
        return this.myStaticImportedClasses;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myDirectives = null;
        this.myImportedClassesNames = null;
        this.myImportedPackagesNames = null;
        this.myJsTagCache = null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "accept"));
        }
        visitor.visitFile((PsiFile)this);
    }

    @Override
    public List<GspDirective> getDirectiveTags(GspDirectiveKind directiveKind, boolean searchInIncludes) {
        List<GspDirective> directives;
        if (searchInIncludes) {
            // empty if block
        }
        if (this.myDirectives == null) {
            final EnumMap<GspDirectiveKind, List<GspDirective>> directivesMap = new EnumMap<GspDirectiveKind, List<GspDirective>>(GspDirectiveKind.class);
            XmlUtil.processXmlElements((XmlElement)this.getRootTag(), (PsiElementProcessor)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    GspDirective directive;
                    GspDirectiveKind directiveKindByTag;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl$1", "execute"));
                    }
                    if (element instanceof GspDirective && (directiveKindByTag = GspDirectiveKind.getKind(directive = (GspDirective)element)) != null) {
                        ArrayList<GspDirective> directives = (ArrayList<GspDirective>)directivesMap.get((Object)directiveKindByTag);
                        if (directives == null) {
                            directives = new ArrayList<GspDirective>();
                            directivesMap.put(directiveKindByTag, directives);
                        }
                        directives.add(directive);
                    }
                    return true;
                }
            }, (boolean)true);
            this.myDirectives = directivesMap;
        }
        return (directives = this.myDirectives.get((Object)directiveKind)) == null ? Collections.emptyList() : directives;
    }

    @Override
    public void addImportForClass(PsiClass aClass) throws IncorrectOperationException {
        this.addImport(aClass.getQualifiedName());
    }

    @Override
    public void addImportStatement(GrImportStatement statement) {
    }

    @Override
    public PsiElement createGroovyScriptletFromText(String text) throws IncorrectOperationException {
        GspPsiElementFactory factory = GspPsiElementFactory.getInstance(this.getProject());
        GspScriptletTag script = factory.createScriptletTagFromText(text);
        GspXmlRootTag rootTag = this.getRootTag();
        assert (rootTag != null);
        PsiElement firstChild = rootTag.getFirstChild();
        if (firstChild != null) {
            rootTag.addBefore((PsiElement)script, firstChild);
        } else {
            rootTag.add((PsiElement)script);
        }
        return script;
    }

    @Override
    public GspXmlRootTag getRootTag() {
        XmlDocument document = this.getDocument();
        assert (document != null);
        PsiElement child = document.getFirstChild();
        assert (child != null);
        return (GspXmlRootTag)child.getNextSibling();
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = super.getViewProvider();
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    private void addImport(String importString) throws IncorrectOperationException {
        GspDirective directive = this.calculatePositionForImport();
        GspPsiElementFactory factory = GspPsiElementFactory.getInstance(this.getProject());
        if (directive != null) {
            XmlAttribute importAttribute = directive.getAttribute("import");
            if (importAttribute != null) {
                importString = importString + "; " + importAttribute.getValue();
            }
            directive.addOrReplaceAttribute(factory.createDirectiveAttribute("import", importString));
        } else {
            GspDirective newDirective = factory.createDirectiveByKind(GspDirectiveKind.PAGE);
            newDirective.addOrReplaceAttribute(factory.createDirectiveAttribute("import", importString));
            GspXmlRootTag rootTag = this.getRootTag();
            assert (rootTag != null);
            PsiElement firstChild = rootTag.getFirstChild();
            if (firstChild != null) {
                rootTag.addBefore((PsiElement)newDirective, firstChild);
            } else {
                rootTag.add((PsiElement)newDirective);
            }
        }
    }

    @Nullable
    private GspDirective calculatePositionForImport() {
        List<GspDirective> directives = this.getDirectiveTags(GspDirectiveKind.PAGE, false);
        if (directives.isEmpty()) {
            return null;
        }
        for (GspDirective directive : directives) {
            if (directive.getAttribute("import") == null) continue;
            return directive;
        }
        return directives.get(0);
    }

    @NotNull
    public FileType getFileType() {
        GspFileType gspFileType = GspFileType.GSP_FILE_TYPE;
        if (gspFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "getFileType"));
        }
        return gspFileType;
    }

    @Nullable
    public XmlDocument getDocument() {
        PsiElement asPsiElement;
        FileElement treeElement = this.calcTreeElement();
        TreeElement firstNode = treeElement.getFirstChildNode();
        if (firstNode != null && (asPsiElement = firstNode.getPsi()) instanceof XmlDocument) {
            return (XmlDocument)asPsiElement;
        }
        return null;
    }

    @Override
    public boolean processJsInJavascriptTags(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "processJsInJavascriptTags"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "processJsInJavascriptTags"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "processJsInJavascriptTags"));
        }
        JSFile fileOfPlace = (JSFile)PsiTreeUtil.getParentOfType((PsiElement)place, JSFile.class);
        for (XmlTag xmlTag : this.getJsTags()) {
            ResolveState s2;
            ASTNode content;
            ASTNode tagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(xmlTag.getNode());
            if (tagEnd == null || (content = tagEnd.getTreeNext()) == null || !(content.getPsi() instanceof OuterLanguageElement)) continue;
            PsiElement injected = InjectedLanguageUtil.findInjectedElementNoCommit((PsiFile)this, (int)content.getStartOffset());
            if ((injected = PsiTreeUtil.getParentOfType((PsiElement)injected, JSFile.class)) == null || injected == fileOfPlace || JSResolveUtil.processDeclarationsInScope((JSElement)((JSElement)injected), (PsiScopeProcessor)processor, (ResolveState)(s2 = state.put(XmlBackedJSClass.PROCESS_XML_BACKED_CLASS_MEMBERS_HINT, (Object)Boolean.TRUE)), null, (PsiElement)place)) continue;
            return false;
        }
        return true;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "processDeclarations"));
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (JavaScriptIntegrationUtil.isJSElement(place)) {
            GspHtmlFileImpl htmlFile = (GspHtmlFileImpl)this.getHtmlLanguageRoot().getOriginalFile();
            return htmlFile.processDeclarations(processor, state, lastParent, place);
        }
        return true;
    }

    private List<XmlTag> getJsTags() {
        List<XmlTag> res = this.myJsTagCache;
        if (res == null) {
            res = new ArrayList<XmlTag>();
            XmlDocument document = (XmlDocument)this.getFirstChild();
            assert (document != null);
            final List<XmlTag> finalRes = res;
            document.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    if (JavaScriptIntegrationUtil.isJsInjectionTag(tag.getName())) {
                        finalRes.add(tag);
                    } else {
                        super.visitXmlTag(tag);
                    }
                }
            });
            this.myJsTagCache = res;
        }
        return res;
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        XmlDocument document = this.getDocument();
        return document == null || document.processElements(processor, place);
    }

    @Override
    public GspHtmlFileImpl getHtmlLanguageRoot() {
        return (GspHtmlFileImpl)this.getViewProvider().getPsi(StdLanguages.HTML);
    }

    @NotNull
    public GlobalSearchScope getFileResolveScope() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this);
        VirtualFile file = this.getVirtualFile();
        if (file != null && this.getOriginalFile() != this) {
            file = this.getOriginalFile().getVirtualFile();
        }
        if (module != null && file != null) {
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
            boolean includeTests = projectFileIndex.isInTestSourceContent(file) || file.getFileType() != StdFileTypes.JAVA || !projectFileIndex.isContentSourceFile(file);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "getFileResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope((Project)this.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/GspFileImpl", "getFileResolveScope"));
        }
        return globalSearchScope;
    }

    public boolean ignoreReferencedElementAccessibility() {
        return false;
    }
}

