/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;

public class GrailsApplicationManagerRefresher
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/GrailsApplicationManagerRefresher", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final GrailsApplicationManager manager = GrailsApplicationManager.getInstance(project);
        MessageBusConnection connection2 = project.getMessageBus().connect();
        connection2.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                Boolean inProgress = (Boolean)project.getUserData(GrailsFramework.UPDATE_IN_PROGRESS);
                if (inProgress != null && inProgress.booleanValue()) {
                    return;
                }
                manager.queueUpdate();
            }
        });
        connection2.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){
            final ProjectFileIndex myFileIndex;
            {
                this.myFileIndex = ProjectFileIndex.getInstance((Project)project);
            }

            boolean shouldClearApplications(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/grails/structure/GrailsApplicationManagerRefresher$2", "shouldClearApplications"));
                }
                VirtualFile file = event.getFile();
                if (!this.myFileIndex.isInContent(file)) {
                    return false;
                }
                String fileName = event.getFileName();
                return file.isDirectory() && fileName.equals("grails-app") || !file.isDirectory() && fileName.equals("application.properties");
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/grails/structure/GrailsApplicationManagerRefresher$2", "fileCreated"));
                }
                if (this.shouldClearApplications(event)) {
                    manager.queueUpdate();
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/grails/structure/GrailsApplicationManagerRefresher$2", "fileDeleted"));
                }
                if (this.shouldClearApplications(event)) {
                    manager.queueUpdate();
                }
            }
        }));
        connection2.subscribe(GradleSettingsListener.TOPIC, (Object)new GradleSettingsListenerAdapter(){

            public void onProjectsLinked(@NotNull Collection<GradleProjectSettings> settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/grails/structure/GrailsApplicationManagerRefresher$3", "onProjectsLinked"));
                }
                manager.queueUpdate();
            }

            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                if (linkedProjectPaths == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPaths", "org/jetbrains/plugins/grails/structure/GrailsApplicationManagerRefresher$3", "onProjectsUnlinked"));
                }
                manager.queueUpdate();
            }
        });
    }
}

