/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.ui;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TextFieldCompletionProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.commands.GrailsCommandCompletionUtil;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.ui.GrailsApplicationCombobox;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.ui.EditorComboBoxWithHistory;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsRunCommandDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JBLabel myApplicationsLabel;
    private GrailsApplicationCombobox myApplications;
    private JBLabel myCommandLabel;
    private EditorComboBoxWithHistory myCommand;
    private JBLabel myVMOptionsLabel;
    private EditorComboBoxWithHistory myVMOptions;
    private final Project myProject;

    public GrailsRunCommandDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog", "<init>"));
        }
        super(project, false, DialogWrapper.IdeModalityType.PROJECT);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myApplicationsLabel.setLabelFor((Component)((Object)this.myApplications));
        this.myApplications.disallowEmptySelection();
        this.myApplications.setApplications(GrailsApplicationManager.getInstance(this.myProject).getApplications());
        this.myApplications.addItemListener(e -> this.checkOkAction());
        this.myCommandLabel.setLabelFor((Component)((Object)this.myCommand));
        this.myCommand.getEditorComponent().addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
                GrailsRunCommandDialog.this.checkOkAction();
            }
        });
        this.installCommandCompletion();
        this.myVMOptionsLabel.setLabelFor((Component)((Object)this.myVMOptions));
        this.installVMOptionsCompletion();
        this.setTitle("Run Grails Command");
        this.init();
        this.checkOkAction();
    }

    private void createUIComponents() {
        this.myCommand = new EditorComboBoxWithHistory(this.myProject, "grails.command.history");
        this.myVMOptions = new EditorComboBoxWithHistory(this.myProject, "grails.vmoptions.history");
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getSelectedApplicationNullable() == null ? this.myApplications : this.myCommand;
    }

    private void checkOkAction() {
        this.setOKActionEnabled(this.isOKEnabled());
    }

    private boolean isOKEnabled() {
        GrailsApplication selectedApplication;
        return !StringUtil.isEmptyOrSpaces((String)this.getCommandString()) && (selectedApplication = this.getSelectedApplicationNullable()) != null && GrailsCommandExecutor.getGrailsExecutor(selectedApplication) != null;
    }

    @Nullable
    private GrailsApplication getSelectedApplicationNullable() {
        return this.myApplications.getSelectedApplication();
    }

    @NotNull
    public GrailsApplication getSelectedApplication() {
        GrailsApplication grailsApplication2 = (GrailsApplication)ObjectUtils.assertNotNull((Object)this.getSelectedApplicationNullable());
        if (grailsApplication2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog", "getSelectedApplication"));
        }
        return grailsApplication2;
    }

    @NotNull
    public GrailsRunCommandDialog setSelectedApplication(@Nullable GrailsApplication application) {
        this.myApplications.setSelectedApplication(application);
        GrailsRunCommandDialog grailsRunCommandDialog = this;
        if (grailsRunCommandDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog", "setSelectedApplication"));
        }
        return grailsRunCommandDialog;
    }

    @NotNull
    public String getCommandString() {
        String string = this.myCommand.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog", "getCommandString"));
        }
        return string;
    }

    @NotNull
    public String getVMOptionsString() {
        String string = this.myVMOptions.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog", "getVMOptionsString"));
        }
        return string;
    }

    @NotNull
    public MvcCommand getCommand() {
        MvcCommand mvcCommand = MvcCommand.parse((String)this.getCommandString()).setVmOptions(this.getVMOptionsString());
        if (mvcCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog", "getCommand"));
        }
        return mvcCommand;
    }

    protected void doOKAction() {
        this.myCommand.save();
        this.myVMOptions.save();
        super.doOKAction();
    }

    private void installCommandCompletion() {
        new TextFieldCompletionProvider(){

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog$2", "addCompletionVariants"));
                }
                if (prefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog$2", "addCompletionVariants"));
                }
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog$2", "addCompletionVariants"));
                }
                result2.addAllElements(GrailsCommandCompletionUtil.collectVariants(GrailsRunCommandDialog.this.getSelectedApplicationNullable(), text, offset, prefix));
            }
        }.apply(this.myCommand.getEditorComponent());
    }

    private void installVMOptionsCompletion() {
        new TextFieldCompletionProvider(){

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog$3", "addCompletionVariants"));
                }
                if (prefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog$3", "addCompletionVariants"));
                }
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog$3", "addCompletionVariants"));
                }
                if (prefix.startsWith("-D")) {
                    result2.addAllElements((Iterable)GrailsCommandCompletionUtil.SYSTEM_PROPERTIES_VARIANTS.getValue());
                }
            }
        }.apply(this.myVMOptions.getEditorComponent());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        GrailsApplicationCombobox grailsApplicationCombobox;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), 5, 5, false, false));
        jPanel.setPreferredSize(new Dimension(500, -1));
        this.myApplicationsLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Application:");
        jBLabel3.setDisplayedMnemonic('A');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApplications = grailsApplicationCombobox = new GrailsApplicationCombobox();
        jPanel.add((Component)((Object)grailsApplicationCombobox), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCommandLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Command:");
        jBLabel2.setDisplayedMnemonic('C');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorComboBoxWithHistory editorComboBoxWithHistory = this.myCommand;
        ((JComboBox)((Object)editorComboBoxWithHistory)).setLightWeightPopupEnabled(false);
        ((JComboBox)((Object)editorComboBoxWithHistory)).setEditable(true);
        jPanel.add((Component)((Object)editorComboBoxWithHistory), new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myVMOptionsLabel = jBLabel = new JBLabel();
        jBLabel.setText("VM options:");
        jBLabel.setDisplayedMnemonic('V');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorComboBoxWithHistory editorComboBoxWithHistory2 = this.myVMOptions;
        ((JComboBox)((Object)editorComboBoxWithHistory2)).setLightWeightPopupEnabled(false);
        ((JComboBox)((Object)editorComboBoxWithHistory2)).setEditable(true);
        jPanel.add((Component)((Object)editorComboBoxWithHistory2), new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

