/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud.action;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.openshift.cloud.DownloadedResourceManager;
import com.intellij.javaee.openshift.cloud.OS3ApplicationRuntime;
import com.intellij.javaee.openshift.cloud.OSBundle;
import com.intellij.javaee.openshift.cloud.action.ResourceActionBase;
import com.intellij.javaee.openshift.cloud.view.OS3TreeStructure;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import org.jetbrains.annotations.NotNull;

public class DownloadResourceAction
extends ResourceActionBase {
    private static final Logger LOG = Logger.getInstance(DownloadResourceAction.class);
    public static final String JSON_EXTENSION = "json";

    public DownloadResourceAction() {
        super(OSBundle.getText("OS3.action.downloadResource.title", new Object[0]), OSBundle.getText("OS3.action.downloadResource.description", new Object[0]), AllIcons.Actions.MoveDown);
    }

    @Override
    protected Class<OS3TreeStructure.OS3DeploymentNode> getTargetNodeClass() {
        return OS3TreeStructure.OS3DeploymentNode.class;
    }

    @Override
    protected void doActionPerformed(ServersToolWindowContent content, OS3ApplicationRuntime<?> applicationRuntime) {
        final Project project = content.getProject();
        FileSaverDescriptor saverDescriptor = new FileSaverDescriptor("Save Resource Descriptor", "Select path to save resource descriptor", new String[]{JSON_EXTENSION});
        FileSaverDialog saveDialog = FileChooserFactory.getInstance().createSaveFileDialog(saverDescriptor, project);
        VirtualFileWrapper fileWrapper = saveDialog.save(null, applicationRuntime.getApplication().getName() + "." + JSON_EXTENSION);
        if (fileWrapper == null) {
            return;
        }
        final String descriptor = applicationRuntime.getApplication().getDescriptor();
        final VirtualFile file = fileWrapper.getVirtualFile(true);
        if (file == null) {
            return;
        }
        new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/openshift/cloud/action/DownloadResourceAction$1", "run"));
                }
                VfsUtil.saveText((VirtualFile)file, (String)descriptor);
                DownloadedResourceManager.getInstance(project).addPath(file.getPath());
                FileEditorManager.getInstance((Project)project).openFile(file, true);
            }
        }.executeSilently().logException(LOG);
    }
}

