/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.profiles.SpringProfile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootProfileConfigFileAutomaticRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/SpringBootProfileConfigFileAutomaticRenamerFactory", "isApplicable"));
        }
        return element instanceof SpringProfile && SpringBootLibraryUtil.hasSpringBootLibrary((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public String getOptionName() {
        return "Spring Boot configuration files";
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        String oldName = ((SpringProfile)element).getName();
        String configFileSuffix = "-" + oldName;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        PsiManager psiManager = element.getManager();
        SmartList allConfigFiles = new SmartList();
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            List matchingConfigFiles = ContainerUtil.filter((Collection)contributor.getConfigurationFiles(module, true), file -> StringUtil.endsWith((CharSequence)file.getNameWithoutExtension(), (CharSequence)configFileSuffix));
            for (VirtualFile configFile : matchingConfigFiles) {
                ContainerUtil.addIfNotNull((Collection)allConfigFiles, (Object)psiManager.findFile(configFile));
            }
        }
        MyAutomaticRenamer myAutomaticRenamer = new MyAutomaticRenamer((List)allConfigFiles, oldName, newName);
        if (myAutomaticRenamer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/SpringBootProfileConfigFileAutomaticRenamerFactory", "createRenamer"));
        }
        return myAutomaticRenamer;
    }

    private static class MyAutomaticRenamer
    extends AutomaticRenamer {
        private final String myOldName;

        private MyAutomaticRenamer(List<PsiFile> configFiles, String oldName, String newName) {
            for (PsiFile file : configFiles) {
                this.myElements.add(file);
                this.suggestAllNames(oldName, newName);
            }
            this.myOldName = oldName;
        }

        public String getDialogTitle() {
            return "Rename Spring Boot Configuration Files";
        }

        public String getDialogDescription() {
            return "Rename Spring Boot configuration files matching Spring Profile '" + this.myOldName + "'";
        }

        public String entityName() {
            return "File";
        }

        protected String suggestNameForElement(PsiNamedElement element, NameSuggester suggester, String newClassName, String oldClassName) {
            String name = element.getName();
            assert (name != null) : element;
            return StringUtil.replace((String)name, (String)("-" + oldClassName), (String)("-" + newClassName));
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        public boolean allowChangeSuggestedName() {
            return false;
        }
    }
}

