/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class NumberHintReferenceBase
extends HintReferenceBase {
    private final Class<? extends Number> myType;

    protected NumberHintReferenceBase(@NotNull PsiElement element, Class<? extends Number> numberType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/NumberHintReferenceBase", "<init>"));
        }
        super(element);
        this.myType = numberType;
    }

    protected abstract void doDecode(String var1) throws NumberFormatException;

    @Override
    @Nullable
    protected final PsiElement doResolve() {
        String value = this.getValue().trim();
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        try {
            this.doDecode(value);
            return this.getElement();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/NumberHintReferenceBase", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = "Cannot convert ''{0}'' to " + this.myType.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/NumberHintReferenceBase", "getUnresolvedMessagePattern"));
        }
        return string;
    }
}

