/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StaticValuesReferenceProvider
extends PsiReferenceProvider {
    private final boolean myAllowOtherValues;
    private final boolean myCaseInsensitive;
    private final String[] values;

    StaticValuesReferenceProvider(boolean allowOtherValues, boolean caseInsensitive, String ... values) {
        this.myAllowOtherValues = allowOtherValues;
        this.myCaseInsensitive = caseInsensitive;
        Arrays.sort(values);
        this.values = values;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{this.createValueReference(element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    @NotNull
    protected final HintReferenceBase createValueReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider", "createValueReference"));
        }
        HintReferenceBase hintReferenceBase = new HintReferenceBase(element){

            @Override
            @Nullable
            protected PsiElement doResolve() {
                if (StaticValuesReferenceProvider.this.myAllowOtherValues) {
                    return this.myElement;
                }
                String value = StaticValuesReferenceProvider.this.myCaseInsensitive ? this.getValue().toUpperCase(Locale.US) : this.getValue();
                return Arrays.binarySearch(StaticValuesReferenceProvider.this.values, value.trim()) > -1 ? this.myElement : null;
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = StaticValuesReferenceProvider.this.values;
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider$1", "getVariants"));
                }
                return objectArray;
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                if (StaticValuesReferenceProvider.this.values.length > 5) {
                    String string = super.getUnresolvedMessagePattern();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider$1", "getUnresolvedMessagePattern"));
                    }
                    return string;
                }
                String string = "Invalid value ''{0}'', must be one of " + StringUtil.join((String[])StaticValuesReferenceProvider.this.values, (String)"|");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider$1", "getUnresolvedMessagePattern"));
                }
                return string;
            }
        };
        if (hintReferenceBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider", "createValueReference"));
        }
        return hintReferenceBase;
    }
}

