/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigMetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigPropertyNameReference;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigValueProviderReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.references.StaticStringValuesReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class SpringBootAdditionalConfigReferenceContributor
extends PsiReferenceContributor {
    private static final Key<SpringBootAdditionalConfigPropertyNameReference.GroupContext> GROUP_CONTEXT_KEY = Key.create((String)"groupContext");
    private static final PatternCondition<JsonProperty> GROUP_CONTEXT = new PatternCondition<JsonProperty>("groupContext"){

        public boolean accepts(@NotNull JsonProperty property, ProcessingContext context) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$1", "accepts"));
            }
            String propertyName = property.getName();
            SpringBootAdditionalConfigPropertyNameReference.GroupContext groupContext = SpringBootAdditionalConfigPropertyNameReference.GroupContext.forProperty(propertyName);
            if (groupContext == null) {
                return false;
            }
            if (SpringBootLibraryUtil.isAtLeastVersion((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)property), (SpringBootLibraryUtil.SpringBootVersion)groupContext.getMinimumVersion())) {
                context.put(GROUP_CONTEXT_KEY, (Object)groupContext);
            }
            return true;
        }
    };
    private static final PsiElementPattern.Capture<JsonProperty> GROUP_CONTEXT_WITH_OBJECT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonProperty.class).with(GROUP_CONTEXT)).with((PatternCondition)new PatternCondition<JsonProperty>("jsonObjectValue"){

        public boolean accepts(@NotNull JsonProperty property, ProcessingContext context) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$2", "accepts"));
            }
            return property.getValue() instanceof JsonObject;
        }
    });
    private static final PsiElementPattern.Capture<JsonProperty> GROUP_CONTEXT_WITH_ARRAY = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonProperty.class).with(GROUP_CONTEXT)).with((PatternCondition)new PatternCondition<JsonProperty>("jsonArrayValue"){

        public boolean accepts(@NotNull JsonProperty property, ProcessingContext context) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$3", "accepts"));
            }
            return property.getValue() instanceof JsonArray;
        }
    });
    private static final PsiFilePattern.Capture<JsonFile> ADDITIONAL_CONFIG_JSON = (PsiFilePattern.Capture)PlatformPatterns.psiFile(JsonFile.class).withName("additional-spring-configuration-metadata.json");
    private static final PsiFilePattern.Capture<JsonFile> SPRING_CONFIGURATION_METADATA_JSON = (PsiFilePattern.Capture)PlatformPatterns.psiFile(JsonFile.class).withName("spring-configuration-metadata.json");
    private static final PatternCondition<JsonStringLiteral> VALUE_PATTERN = new PatternCondition<JsonStringLiteral>("inPropertyValue"){

        public boolean accepts(@NotNull JsonStringLiteral property, ProcessingContext context) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$4", "accepts"));
            }
            return JsonPsiUtil.isPropertyValue((PsiElement)property);
        }
    };
    private static final PatternCondition<JsonStringLiteral> PROPERTY_PATTERN = new PatternCondition<JsonStringLiteral>("inPropertyKey"){

        public boolean accepts(@NotNull JsonStringLiteral property, ProcessingContext context) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$5", "accepts"));
            }
            return JsonPsiUtil.isPropertyKey((PsiElement)property);
        }
    };
    private static final PatternCondition<JsonProperty> NAME_PROPERTY = new PatternCondition<JsonProperty>("nameProperty"){

        public boolean accepts(@NotNull JsonProperty property, ProcessingContext context) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$6", "accepts"));
            }
            return "name".equals(property.getName());
        }
    };

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor", "registerReferenceProviders"));
        }
        final JavaClassReferenceProvider originalClassReferenceProvider = new JavaClassReferenceProvider();
        originalClassReferenceProvider.setOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES, (Object)Boolean.TRUE);
        PsiReferenceProvider javaClassReferenceProvider = new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$7", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$7", "getReferencesByElement"));
                }
                JavaClassReferenceSet set = new JavaClassReferenceSet(ElementManipulators.getValueText((PsiElement)element), element, ElementManipulators.getOffsetInElement((PsiElement)element), false, originalClassReferenceProvider){

                    public boolean isAllowDollarInNames() {
                        return true;
                    }
                };
                JavaClassReference[] javaClassReferenceArray = set.getAllReferences();
                if (javaClassReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$7", "getReferencesByElement"));
                }
                return javaClassReferenceArray;
            }
        };
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(StandardPatterns.or((ElementPattern[])new ElementPattern[]{ADDITIONAL_CONFIG_JSON, SPRING_CONFIGURATION_METADATA_JSON}))).with(VALUE_PATTERN)).withParent((ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).with((PatternCondition)new PatternCondition<JsonProperty>("classPropertyNames"){

            public boolean accepts(@NotNull JsonProperty property, ProcessingContext context) {
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$8", "accepts"));
                }
                String name = property.getName();
                return "type".equals(name) || "sourceType".equals(name);
            }
        }))).withSuperParent(4, GROUP_CONTEXT_WITH_ARRAY), javaClassReferenceProvider);
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(StandardPatterns.or((ElementPattern[])new ElementPattern[]{ADDITIONAL_CONFIG_JSON, SPRING_CONFIGURATION_METADATA_JSON}))).with(VALUE_PATTERN)).with(SpringBootLibraryUtil.SB_1_3_OR_HIGHER)).withParent((ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).with((PatternCondition)new PatternCondition<JsonProperty>("targetProperty"){

            public boolean accepts(@NotNull JsonProperty property, ProcessingContext context) {
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$9", "accepts"));
                }
                return "target".equals(property.getName());
            }
        }))).withSuperParent(3, GROUP_CONTEXT_WITH_OBJECT), javaClassReferenceProvider);
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(ADDITIONAL_CONFIG_JSON)).with(PROPERTY_PATTERN)).withSuperParent(3, (ElementPattern)PlatformPatterns.psiFile(JsonFile.class)), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$10", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$10", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBootAdditionalConfigPropertyNameReference(element, SpringBootAdditionalConfigPropertyNameReference.GroupContext.FAKE_TOP_LEVEL)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$10", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        PsiReferenceProvider propertyNamesProvider = new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$11", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$11", "getReferencesByElement"));
                }
                SpringBootAdditionalConfigPropertyNameReference.GroupContext groupContext = (SpringBootAdditionalConfigPropertyNameReference.GroupContext)((Object)context.get(GROUP_CONTEXT_KEY));
                if (groupContext == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$11", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBootAdditionalConfigPropertyNameReference(element, groupContext)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$11", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        };
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(ADDITIONAL_CONFIG_JSON)).with(PROPERTY_PATTERN)).withSuperParent(4, GROUP_CONTEXT_WITH_ARRAY), propertyNamesProvider);
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(ADDITIONAL_CONFIG_JSON)).with(PROPERTY_PATTERN)).withSuperParent(3, GROUP_CONTEXT_WITH_OBJECT), propertyNamesProvider);
        PatternCondition<JsonStringLiteral> deprecationGroupPattern = new PatternCondition<JsonStringLiteral>("deprecationGroup"){

            public boolean accepts(@NotNull JsonStringLiteral literal, ProcessingContext context) {
                if (literal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$12", "accepts"));
                }
                return ((SpringBootAdditionalConfigPropertyNameReference.GroupContext)((Object)context.get(GROUP_CONTEXT_KEY))).equals((Object)SpringBootAdditionalConfigPropertyNameReference.GroupContext.DEPRECATION);
            }
        };
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(ADDITIONAL_CONFIG_JSON)).with(VALUE_PATTERN)).with(SpringBootLibraryUtil.SB_1_3_OR_HIGHER)).withParent((ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).with((PatternCondition)new PatternCondition<JsonProperty>("replacementProperty"){

            public boolean accepts(@NotNull JsonProperty jsonProperty, ProcessingContext context) {
                if (jsonProperty == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonProperty", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$14", "accepts"));
                }
                return jsonProperty.getName().equals("replacement");
            }
        }))).withSuperParent(3, GROUP_CONTEXT_WITH_OBJECT)).with((PatternCondition)deprecationGroupPattern), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$13", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$13", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBootAdditionalConfigMetaConfigKeyReference(element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$13", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        String[] deprecationLevels = (String[])ContainerUtil.map2Array((Object[])SpringBootApplicationMetaConfigKey.Deprecation.DeprecationLevel.values(), String.class, t -> t.getValue());
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(ADDITIONAL_CONFIG_JSON)).with(VALUE_PATTERN)).with(SpringBootLibraryUtil.SB_1_5_OR_HIGHER)).withParent((ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).with((PatternCondition)new PatternCondition<JsonProperty>("levelProperty"){

            public boolean accepts(@NotNull JsonProperty jsonProperty, ProcessingContext context) {
                if (jsonProperty == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonProperty", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$15", "accepts"));
                }
                return jsonProperty.getName().equals("level");
            }
        }))).withSuperParent(3, GROUP_CONTEXT_WITH_OBJECT)).with((PatternCondition)deprecationGroupPattern), (PsiReferenceProvider)new StaticStringValuesReferenceProvider(false, deprecationLevels));
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(ADDITIONAL_CONFIG_JSON)).with(VALUE_PATTERN)).with(SpringBootLibraryUtil.SB_1_3_OR_HIGHER)).withParent((ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).with(NAME_PROPERTY))).withSuperParent(4, GROUP_CONTEXT_WITH_ARRAY)).with((PatternCondition)new PatternCondition<JsonStringLiteral>("hintsProvidersGroup"){

            public boolean accepts(@NotNull JsonStringLiteral literal, ProcessingContext context) {
                if (literal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$17", "accepts"));
                }
                return ((SpringBootAdditionalConfigPropertyNameReference.GroupContext)((Object)context.get(GROUP_CONTEXT_KEY))).equals((Object)SpringBootAdditionalConfigPropertyNameReference.GroupContext.HINTS_PROVIDERS);
            }
        }), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$16", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$16", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBootAdditionalConfigValueProviderReference(element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$16", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(ADDITIONAL_CONFIG_JSON)).with(VALUE_PATTERN)).with(SpringBootLibraryUtil.SB_1_3_OR_HIGHER)).withParent((ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).with(NAME_PROPERTY))).withSuperParent(4, GROUP_CONTEXT_WITH_ARRAY)).with((PatternCondition)new PatternCondition<JsonStringLiteral>("hintsGroup"){

            public boolean accepts(@NotNull JsonStringLiteral literal, ProcessingContext context) {
                if (literal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$19", "accepts"));
                }
                return ((SpringBootAdditionalConfigPropertyNameReference.GroupContext)((Object)context.get(GROUP_CONTEXT_KEY))).equals((Object)SpringBootAdditionalConfigPropertyNameReference.GroupContext.HINTS);
            }
        }), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$18", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$18", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBootAdditionalConfigMetaConfigKeyReference(element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigReferenceContributor$18", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }
}

