/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.banner.AnsiColor;
import com.intellij.spring.boot.banner.AnsiStyle;
import com.intellij.spring.boot.banner.BuiltinProperty;
import com.intellij.spring.boot.banner.SpringBootBannerPropertyReference;
import com.intellij.spring.boot.banner.SpringBootBannerReferenceContributor;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.ColorIconCache;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootBannerCompletionContributor
extends CompletionContributor {
    static final String ANSI_STYLE_PREFIX = "AnsiStyle.";
    static final String ANSI_COLOR_PREFIX = "AnsiColor.";
    static final String ANSI_BACKGROUND_PREFIX = "AnsiBackground.";
    private static final String PROPERTY_REFERENCE_PLACEHOLDER = "${}";
    private static final InsertHandler<LookupElement> PROPERTY_REFERENCE_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            editor.getCaretModel().moveCaretRelatively(-"}".length(), 0, false, false, false);
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(editor);
        }
    };

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/boot/banner/SpringBootBannerCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/boot/banner/SpringBootBannerCompletionContributor", "fillCompletionVariants"));
        }
        if (!SpringBootBannerReferenceContributor.PATTERN.accepts((Object)parameters.getOriginalFile())) {
            return;
        }
        PsiReference reference = parameters.getOriginalFile().findReferenceAt(parameters.getOffset());
        if (reference instanceof SpringBootBannerPropertyReference) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)parameters.getOriginalFile());
            SpringBootBannerCompletionContributor.addReferenceCompletionVariants(module, result);
        } else {
            result.addElement((LookupElement)LookupElementBuilder.create((String)PROPERTY_REFERENCE_PLACEHOLDER).bold().withTailText(" Insert new property reference", true).withInsertHandler(PROPERTY_REFERENCE_INSERT_HANDLER));
        }
        result.stopHere();
    }

    private static void addReferenceCompletionVariants(@Nullable Module module, @NotNull CompletionResultSet result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/boot/banner/SpringBootBannerCompletionContributor", "addReferenceCompletionVariants"));
        }
        if (module == null) {
            return;
        }
        for (BuiltinProperty builtinProperty : BuiltinProperty.values()) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)builtinProperty.getPropertyName()).bold().withIcon(AllIcons.Nodes.Property).withTailText(" " + builtinProperty.getTailText(module), true));
        }
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            return;
        }
        for (Enum enum_ : AnsiStyle.values()) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)(ANSI_STYLE_PREFIX + enum_.name())));
        }
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        int colorPreviewSize = UIUtil.getListFont().getSize();
        Icon backGroundColorOverlayIcon = IconUtil.toSize((Icon)AllIcons.Graph.Grid, (int)colorPreviewSize, (int)colorPreviewSize);
        for (AnsiColor ansiColor : AnsiColor.values()) {
            Color color = colorsScheme.getAttributes(ansiColor.getTextAttributesKey()).getForegroundColor();
            Icon colorIcon = ColorIconCache.getIconCache().getIcon(color, colorPreviewSize);
            result.addElement((LookupElement)LookupElementBuilder.create((String)(ANSI_COLOR_PREFIX + ansiColor.name())).withIcon(colorIcon));
            result.addElement((LookupElement)LookupElementBuilder.create((String)(ANSI_BACKGROUND_PREFIX + ansiColor.name())).withIcon((Icon)new LayeredIcon(new Icon[]{colorIcon, backGroundColorOverlayIcon})));
        }
    }
}

