/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.testing.jam.custom.providers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.model.testing.jam.SpringBootstrapWithTest;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestingImplicitContextsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootstrapImplicitBeansProvider
extends SpringTestingImplicitContextsProvider {
    @NotNull
    public Collection<CommonSpringModel> getModels(@Nullable Module module, @NotNull ContextConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootstrapImplicitBeansProvider", "getModels"));
        }
        if (module == null) {
            List<CommonSpringModel> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootstrapImplicitBeansProvider", "getModels"));
            }
            return list;
        }
        List models = ContainerUtil.newSmartList();
        final GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true);
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        if (configuration instanceof SpringBootstrapWithTest) {
            models.add(new BeansSpringModel(module, (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                @NotNull
                protected Collection<? extends SpringBeanPointer> compute() {
                    Set set = BeanService.getInstance().mapSpringBeans((Collection)SpringBootstrapImplicitBeansProvider.getImplicitBeans(facade, searchScope));
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootstrapImplicitBeansProvider$1", "compute"));
                    }
                    return set;
                }
            }));
        }
        List list = models;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootstrapImplicitBeansProvider", "getModels"));
        }
        return list;
    }

    @NotNull
    private static List<CommonSpringBean> getImplicitBeans(JavaPsiFacade facade, GlobalSearchScope searchScope) {
        List beans = ContainerUtil.newSmartList();
        ContainerUtil.addIfNotNull((Collection)beans, (Object)SpringImplicitBean.create((String)"Testing Beans", (PsiClass)facade.findClass("org.springframework.boot.test.web.client.TestRestTemplate", searchScope), (String)"testRestTemplate"));
        List list = beans;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootstrapImplicitBeansProvider", "getImplicitBeans"));
        }
        return list;
    }
}

