/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.options;

import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.options.SpringBootSettings;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTabConfigurable;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class SpringBootSettingsUi
implements ConfigurableUi<SpringBootSettings> {
    private JPanel myRootPanel;
    private JBCheckBox myAdditionalConfigJsonShowPanel;
    private JBCheckBox myInitializrAutoCreateRunConfiguration;
    private JPanel myDashboardEndpointsPanel;
    private final Project myProject;

    SpringBootSettingsUi(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    public void reset(@NotNull SpringBootSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/boot/options/SpringBootSettingsUi", "reset"));
        }
        this.myAdditionalConfigJsonShowPanel.setSelected(settings.isShowAdditionalConfigNotification());
        this.myInitializrAutoCreateRunConfiguration.setSelected(settings.isAutoCreateRunConfiguration());
        for (EndpointTabConfigurable tabConfigurable : this.getEndpointTabConfigurables()) {
            tabConfigurable.reset();
        }
    }

    public boolean isModified(@NotNull SpringBootSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/boot/options/SpringBootSettingsUi", "isModified"));
        }
        if (this.hasModifiedEditorSettings(settings)) {
            return true;
        }
        if (this.myInitializrAutoCreateRunConfiguration.isSelected() != settings.isAutoCreateRunConfiguration()) {
            return true;
        }
        for (EndpointTabConfigurable tabConfigurable : this.getEndpointTabConfigurables()) {
            if (!tabConfigurable.isModified()) continue;
            return true;
        }
        return false;
    }

    private boolean hasModifiedEditorSettings(@NotNull SpringBootSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/boot/options/SpringBootSettingsUi", "hasModifiedEditorSettings"));
        }
        return this.myAdditionalConfigJsonShowPanel.isSelected() != settings.isShowAdditionalConfigNotification();
    }

    public void apply(@NotNull SpringBootSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/boot/options/SpringBootSettingsUi", "apply"));
        }
        if (this.hasModifiedEditorSettings(settings)) {
            settings.setShowAdditionalConfigNotification(this.myAdditionalConfigJsonShowPanel.isSelected());
            EditorNotifications.updateAll();
        }
        settings.setAutoCreateRunConfiguration(this.myInitializrAutoCreateRunConfiguration.isSelected());
        for (EndpointTabConfigurable tabConfigurable : this.getEndpointTabConfigurables()) {
            tabConfigurable.apply();
        }
    }

    @NotNull
    public JComponent getComponent() {
        int row = 0;
        for (EndpointTabConfigurable tabConfigurable : this.getEndpointTabConfigurables()) {
            JComponent component = tabConfigurable.createComponent();
            assert (component instanceof JPanel) : tabConfigurable;
            JPanel panel = (JPanel)component;
            panel.setBorder(IdeBorderFactory.createTitledBorder((String)tabConfigurable.getDisplayName()));
            GridConstraints constraint = new GridConstraints();
            constraint.setRow(row++);
            constraint.setIndent(1);
            constraint.setAnchor(9);
            this.myDashboardEndpointsPanel.add((Component)component, constraint);
        }
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/options/SpringBootSettingsUi", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    private EndpointTabConfigurable[] getEndpointTabConfigurables() {
        EndpointTabConfigurable[] endpointTabConfigurableArray = (EndpointTabConfigurable[])this.myProject.getExtensions(EndpointTabConfigurable.EP_NAME);
        if (endpointTabConfigurableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/options/SpringBootSettingsUi", "getEndpointTabConfigurables"));
        }
        return endpointTabConfigurableArray;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Font font = jPanel3.getFont();
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Configuration Metadata Files", (int)1, (int)0, (Font)new Font(font.getName(), font.getStyle(), font.getSize()), null));
        this.myAdditionalConfigJsonShowPanel = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Show notification panel");
        jBCheckBox2.setMnemonic('N');
        jBCheckBox2.setDisplayedMnemonicIndex(5);
        jBCheckBox2.setToolTipText("Shows status of annotation processor availability and link to documentation");
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDashboardEndpointsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Run Configuration: Endpoints Tabs", (int)0, (int)0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Initializr", (int)0, (int)0, null, null));
        this.myInitializrAutoCreateRunConfiguration = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Create Run Configuration automatically");
        jBCheckBox.setMnemonic('R');
        jBCheckBox.setDisplayedMnemonicIndex(7);
        jBCheckBox.setToolTipText("On (re-)import add Spring Boot run configuration if none exists yet");
        jPanel4.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

