/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;
import org.junit.vintage.engine.discovery.IsPotentialJUnit4TestMethod;

class DefensiveAllDefaultPossibilitiesBuilder
extends AllDefaultPossibilitiesBuilder {
    private static final Logger LOG = Logger.getLogger(DefensiveAllDefaultPossibilitiesBuilder.class.getName());
    private final AnnotatedBuilder annotatedBuilder = new DefensiveAnnotatedBuilder((RunnerBuilder)this);
    private final DefensiveJUnit4Builder defensiveJUnit4Builder = new DefensiveJUnit4Builder();

    DefensiveAllDefaultPossibilitiesBuilder() {
        super(true);
    }

    protected AnnotatedBuilder annotatedBuilder() {
        return this.annotatedBuilder;
    }

    protected JUnit4Builder junit4Builder() {
        return this.defensiveJUnit4Builder;
    }

    private static class DefensiveJUnit4Builder
    extends JUnit4Builder {
        private static final Predicate<Method> isPotentialJUnit4TestMethod = new IsPotentialJUnit4TestMethod();

        private DefensiveJUnit4Builder() {
        }

        public Runner runnerForClass(Class<?> testClass) throws Throwable {
            if (this.containsTestMethods(testClass)) {
                return super.runnerForClass(testClass);
            }
            return null;
        }

        private boolean containsTestMethods(Class<?> testClass) {
            return ReflectionUtils.isMethodPresent(testClass, isPotentialJUnit4TestMethod);
        }
    }

    private static class DefensiveAnnotatedBuilder
    extends AnnotatedBuilder {
        DefensiveAnnotatedBuilder(RunnerBuilder suiteBuilder) {
            super(suiteBuilder);
        }

        public Runner buildRunner(Class<? extends Runner> runnerClass, Class<?> testClass) throws Exception {
            if ("org.junit.platform.runner.JUnitPlatform".equals(runnerClass.getName())) {
                LOG.log(Level.WARNING, () -> "Ignoring test class using JUnitPlatform runner: " + testClass.getName());
                return null;
            }
            return super.buildRunner(runnerClass, testClass);
        }
    }
}

