/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.base;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTagRefactoringHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/sixrr/xrp/base/BaseTagRefactoringHandler", "invoke"));
        }
        XmlTag selectedTag = BaseTagRefactoringHandler.findSelectedTag(editor, file);
        if (selectedTag != null) {
            String message = this.getProblemMessage(selectedTag);
            if (message != null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)this.getHelpID());
            } else {
                this.handleTag(selectedTag, project);
            }
        } else {
            String message = "Cannot perform the refactoring.\nThe caret should be positioned at a tag to be refactored.";
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform the refactoring.\nThe caret should be positioned at a tag to be refactored.", (String)this.getRefactoringName(), (String)this.getHelpID());
        }
    }

    @Nullable
    protected String getProblemMessage(XmlTag tag) {
        return null;
    }

    protected abstract String getHelpID();

    protected abstract String getRefactoringName();

    private static XmlTag findSelectedTag(Editor editor, PsiFile file) {
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        for (PsiElement element = file.findElementAt(position); element != null; element = element.getParent()) {
            if (!(element instanceof XmlTag)) continue;
            return (XmlTag)element;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/sixrr/xrp/base/BaseTagRefactoringHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/sixrr/xrp/base/BaseTagRefactoringHandler", "invoke"));
        }
        if (elements.length == 1 && elements[0] instanceof XmlTag) {
            this.handleTag((XmlTag)elements[0], project);
        }
    }

    protected abstract void handleTag(XmlTag var1, Project var2);
}

