/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.xml.converters;

import com.intellij.openapi.module.Module;
import com.intellij.seam.model.xml.PageflowDomModelManager;
import com.intellij.seam.model.xml.PageflowModel;
import com.intellij.seam.model.xml.pageflow.PageflowDefinition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageflowDefinitionConverter
extends ResolvingConverter<PageflowDefinition> {
    @NotNull
    public Collection<PageflowDefinition> getVariants(ConvertContext context) {
        List<PageflowDefinition> list = PageflowDefinitionConverter.getPageflowDefinitions(context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/xml/converters/PageflowDefinitionConverter", "getVariants"));
        }
        return list;
    }

    public PageflowDefinition fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        List<PageflowDefinition> pageflowDefinitions = PageflowDefinitionConverter.getPageflowDefinitions(context);
        for (PageflowDefinition definition : pageflowDefinitions) {
            if (!s.equals(definition.getName().getStringValue())) continue;
            return definition;
        }
        return null;
    }

    @NotNull
    private static List<PageflowDefinition> getPageflowDefinitions(ConvertContext context) {
        Module module = context.getModule();
        List<PageflowModel> models = PageflowDomModelManager.getInstance(module.getProject()).getAllModels(module);
        List list = ContainerUtil.map2List(models, pageflowModel -> (PageflowDefinition)((DomFileElement)pageflowModel.getRoots().get(0)).getRootElement());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/xml/converters/PageflowDefinitionConverter", "getPageflowDefinitions"));
        }
        return list;
    }

    public String toString(@Nullable PageflowDefinition pageflowDefinition, ConvertContext context) {
        return pageflowDefinition == null ? null : pageflowDefinition.getName().getStringValue();
    }
}

