/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShowDiagramBase
extends DumbAwareAction {
    private boolean myIsCalledFromList = false;

    protected ShowDiagramBase() {
        this.setInjectedContext(true);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (e.getProject() == null) {
            presentation.setEnabled(false);
            return;
        }
        DiagramProvider provider = (DiagramProvider)this.getProviders(e).first();
        boolean enabled = provider != null;
        String place = e.getPlace();
        presentation.setVisible(enabled || DiagramProvider.isEverybodyInThePlaceLetsGo((String)place));
        presentation.setEnabled(enabled);
        if (enabled) {
            presentation.setIcon(provider.getActionIcon(this.isPopup()));
            presentation.setText("Show " + provider.getActionName(this.isPopup()) + (this.isPopup() ? " Popup" : "") + "...");
        }
    }

    @NotNull
    private JBIterable<DiagramProvider> getProviders(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/core/actions/ShowDiagramBase", "getProviders"));
        }
        JBIterable<DiagramProvider> jBIterable = ShowDiagramBase.findProviders(e, this.getProvider(e));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/core/actions/ShowDiagramBase", "getProviders"));
        }
        return jBIterable;
    }

    protected abstract boolean isPopup();

    @Nullable
    public DiagramProvider getProvider(AnActionEvent e) {
        return null;
    }

    public String getFeatureId() {
        return "diagram.show";
    }

    public boolean isCalledFromJList() {
        return this.myIsCalledFromList;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DataContext context = e.getDataContext();
        List providers = this.getProviders(e).toList();
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureId());
        if (providers.isEmpty()) {
            return;
        }
        Component comp = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        AbstractPopup.MyContentPanel panel = comp == null ? null : (AbstractPopup.MyContentPanel)UIUtil.getParentOfType(AbstractPopup.MyContentPanel.class, (Component)comp);
        this.myIsCalledFromList = panel != null;
        RelativePoint point = this.getLocation(context, e);
        if (providers.size() > 1) {
            ArrayList target = ContainerUtil.newArrayListWithCapacity((int)providers.size());
            ArrayList otherTargets = ContainerUtil.newArrayListWithCapacity((int)providers.size());
            for (DiagramProvider provider : providers) {
                target.add(this.findInDataContext(provider, context));
                otherTargets.add(provider.getElementManager().findElementsInDataContext(context));
            }
            JBList jList = new JBList((Collection)providers);
            jList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<DiagramProvider>(){

                protected void customizeCellRenderer(@NotNull JList<? extends DiagramProvider> list, DiagramProvider provider, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/uml/core/actions/ShowDiagramBase$1", "customizeCellRenderer"));
                    }
                    this.append(provider.getPresentableName());
                    this.setIcon(provider.getActionIcon(ShowDiagramBase.this.isPopup()));
                }
            });
            PopupChooserBuilder popupBuilder = JBPopupFactory.getInstance().createListPopupBuilder((JList)jList);
            JBPopup popup = popupBuilder.setTitle(UmlBundle.message("select.uml.provider", new Object[0])).setResizable(false).setMovable(false).setItemChoosenCallback(() -> {
                int index = jList.getSelectedIndex();
                if (0 <= index && index < providers.size()) {
                    this.showUnderProgress((DiagramProvider)providers.get(index), project, target.get(index), (Collection)otherTargets.get(index), point);
                }
            }).createPopup();
            popup.showInBestPositionFor(context);
        } else {
            DiagramProvider provider = (DiagramProvider)providers.get(0);
            ArrayList elements = provider.getElementManager().findElementsInDataContext(context);
            if (elements.size() > 0) {
                elements = new ArrayList(elements);
            }
            this.showUnderProgress(provider, project, this.findInDataContext(provider, context), elements, point);
        }
    }

    protected Object findInDataContext(DiagramProvider provider, DataContext context) {
        return provider.getElementManager().findInDataContext(context);
    }

    @NotNull
    protected RelativePoint getLocation(DataContext context, AnActionEvent e) {
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(context);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/core/actions/ShowDiagramBase", "getLocation"));
        }
        return relativePoint;
    }

    @Nullable
    protected abstract Runnable show(Object var1, DiagramProvider var2, Project var3, RelativePoint var4, Collection var5);

    protected void showUnderProgress(DiagramProvider provider, Project project, @Nullable Object element, Collection elements, RelativePoint point) {
        UsageTrigger.trigger((String)("uml.ShowDiagram." + provider.getID() + (this.isPopup() ? ".popup" : "")));
        Ref postbackAction = Ref.create(null);
        Object obj = element != null ? element : (!elements.isEmpty() ? elements.iterator().next() : null);
        elements.remove(obj);
        Runnable process = () -> ApplicationManager.getApplication().runReadAction(() -> {
            ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
            Runnable callback = this.show(obj, provider, project, point, elements);
            if (this.isPopup()) {
                postbackAction.set((Object)callback);
            } else if (callback != null) {
                callback.run();
            }
        });
        if (this.isUnderProgress() && !this.isCalledFromJList()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process, UmlBundle.message("building.diagram", provider.getPresentableName()), true, project);
        } else {
            postbackAction.set((Object)this.show(obj, provider, project, point, elements));
        }
        if (!postbackAction.isNull()) {
            ((Runnable)postbackAction.get()).run();
        }
    }

    protected boolean isUnderProgress() {
        return true;
    }

    @NotNull
    public static JBIterable<DiagramProvider> findProviders(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/core/actions/ShowDiagramBase", "findProviders"));
        }
        JBIterable<DiagramProvider> jBIterable = ShowDiagramBase.findProviders(e, null);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/core/actions/ShowDiagramBase", "findProviders"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DiagramProvider> findProviders(@NotNull AnActionEvent e, @Nullable DiagramProvider forcedProvider) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/core/actions/ShowDiagramBase", "findProviders"));
        }
        Project project = e.getProject();
        if (project == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/core/actions/ShowDiagramBase", "findProviders"));
            }
            return jBIterable;
        }
        String place = e.getPlace();
        boolean isDumb = DumbService.isDumb((Project)project);
        JBIterable jBIterable = (forcedProvider != null ? JBIterable.of((Object)forcedProvider) : JBIterable.of((Object[])DiagramProvider.DIAGRAM_PROVIDER.getExtensions())).filter(provider -> !isDumb || DumbService.isDumbAware((Object)provider)).filter(provider -> {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/core/actions/ShowDiagramBase", "lambda$findProviders$4"));
            }
            DiagramElementManager mgr = provider.getElementManager();
            Object element = mgr.findInDataContext(e.getDataContext());
            Collection elements = mgr.findElementsInDataContext(e.getDataContext());
            List places = provider.getActionPlaces();
            element = element == null ? (!elements.isEmpty() ? elements.toArray()[0] : null) : element;
            return element != null && mgr.isAcceptableAsNode(element) && (places == null || places.contains(place) || places.isEmpty());
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/core/actions/ShowDiagramBase", "findProviders"));
        }
        return jBIterable;
    }
}

