/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.diff;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uml.diff.UmlDiffElement;

public class DiffUmlElementManager
extends AbstractDiagramElementManager<UmlDiffElement> {
    public UmlDiffElement findInDataContext(DataContext context) {
        VcsFileRevision revision = (VcsFileRevision)VcsDataKeys.VCS_FILE_REVISION.getData(context);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (revision == null || project == null || virtualFile == null) {
            return null;
        }
        VirtualFile dir = virtualFile.getParent();
        if (dir == null) {
            return null;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(dir);
        if (vcs == null) {
            return null;
        }
        return new UmlDiffElement(vcs, revision, virtualFile);
    }

    public boolean isAcceptableAsNode(Object element) {
        return false;
    }

    public Object[] getNodeItems(UmlDiffElement parent) {
        return parent.getChanges();
    }

    public boolean canCollapse(UmlDiffElement element) {
        return false;
    }

    public boolean isContainerFor(UmlDiffElement container, UmlDiffElement element) {
        return false;
    }

    public String getElementTitle(UmlDiffElement element) {
        return element.getNodeName();
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof UmlDiffElement) {
            UmlDiffElement diffElement = (UmlDiffElement)element;
            return new SimpleColoredText(diffElement.getNodeName(), new SimpleTextAttributes(1, diffElement.getNodeStatus().getColor()));
        }
        if (element instanceof UmlDiffElement.NodeElementHolder) {
            return ((UmlDiffElement.NodeElementHolder)element).getName();
        }
        return null;
    }

    public SimpleColoredText getItemType(Object element) {
        if (element instanceof UmlDiffElement.NodeElementHolder) {
            return ((UmlDiffElement.NodeElementHolder)element).getType();
        }
        return null;
    }

    public String getNodeTooltip(UmlDiffElement element) {
        return null;
    }
}

