/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.license;

import com.android.tools.idea.actions.license.LicenseTextCollector;
import com.android.tools.idea.actions.license.LicensesLocator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowLicensesUsedAction
extends DumbAwareAction {
    public ShowLicensesUsedAction() {
        super("_Licenses");
    }

    public void actionPerformed(final AnActionEvent e) {
        final Project project = ShowLicensesUsedAction.getEventProject((AnActionEvent)e);
        new Task.Backgroundable(project, "Collecting Licenses", true){
            public String myLicenseText;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/actions/license/ShowLicensesUsedAction$1", "run"));
                }
                indicator.setIndeterminate(true);
                Path ideHome = Paths.get(PathManager.getHomePath(), new String[0]);
                LicensesLocator locator = new LicensesLocator(ideHome, SystemInfo.isMac);
                CompletableFuture<String> cf = new LicenseTextCollector(ideHome, locator.getLicenseFiles()).getLicenseText();
                while (!indicator.isCanceled()) {
                    try {
                        this.myLicenseText = cf.get(100L, TimeUnit.MILLISECONDS);
                        return;
                    }
                    catch (InterruptedException e2) {
                        return;
                    }
                    catch (ExecutionException e3) {
                        throw new RuntimeException(e3.getCause());
                    }
                    catch (TimeoutException timeoutException) {
                    }
                }
            }

            public void onSuccess() {
                LicenseDialog licenseDialog = new LicenseDialog(project, this.myLicenseText);
                licenseDialog.init();
                try {
                    licenseDialog.show();
                }
                catch (Exception ex) {
                    Logger.getInstance(ShowLicensesUsedAction.class).error((Object)e);
                }
            }

            public void onError(@NotNull Exception error) {
                if (error == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/actions/license/ShowLicensesUsedAction$1", "onError"));
                }
                Messages.showErrorDialog((Project)project, (String)("Error collecting licenses: " + error.toString()), (String)"Show Licenses");
            }
        }.queue();
    }

    private static class LicenseDialog
    extends DialogWrapper {
        private final String myLicenseText;

        protected LicenseDialog(@Nullable Project project, @NotNull String licenseText) {
            if (licenseText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "licenseText", "com/android/tools/idea/actions/license/ShowLicensesUsedAction$LicenseDialog", "<init>"));
            }
            super(project);
            this.getWindow().setMinimumSize((Dimension)JBUI.size((int)600, (int)400));
            this.myLicenseText = licenseText;
        }

        protected void init() {
            super.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            String text = "<html>" + this.myLicenseText + "</html>";
            JTextPane label = new JTextPane();
            label.setContentType("text/html");
            label.setText(text);
            JBScrollPane pane = new JBScrollPane((Component)label);
            pane.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
            panel.add((Component)pane, "Center");
            return panel;
        }
    }
}

