/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.StepData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.assistant.view.CardViewPanel;
import com.android.tools.idea.assistant.view.NavigationButton;
import com.android.tools.idea.assistant.view.TutorialStep;
import com.android.tools.idea.assistant.view.UIUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TutorialCard
extends CardViewPanel {
    JBScrollPane myContentsScroller;
    String myTutorialsTitle;

    TutorialCard(@NotNull ActionListener listener, @NotNull TutorialData tutorial, @NotNull FeatureData feature, @NotNull String tutorialsTitle, @NotNull Project project, boolean hideChooserAndNavigationalBar) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/assistant/view/TutorialCard", "<init>"));
        }
        if (tutorial == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tutorial", "com/android/tools/idea/assistant/view/TutorialCard", "<init>"));
        }
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/android/tools/idea/assistant/view/TutorialCard", "<init>"));
        }
        if (tutorialsTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tutorialsTitle", "com/android/tools/idea/assistant/view/TutorialCard", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/assistant/view/TutorialCard", "<init>"));
        }
        super(listener);
        this.myContentsScroller = new JBScrollPane();
        this.myTutorialsTitle = tutorialsTitle;
        if (!hideChooserAndNavigationalBar) {
            this.add((Component)new HeaderNav(feature.getName(), this.myListener), "North");
        }
        JPanel contents = new JPanel();
        contents.setLayout(new GridBagLayout());
        contents.setOpaque(false);
        contents.setAlignmentX(0.0f);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = JBUI.insetsBottom((int)5);
        JBLabel title = new JBLabel(tutorial.getLabel());
        title.setFont(title.getFont().deriveFont(1, 16.0f));
        title.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        if (tutorial.getIcon() != null) {
            title.setIcon(tutorial.getIcon());
        }
        contents.add((Component)title, c);
        ++c.gridy;
        TutorialDescription description = new TutorialDescription();
        StringBuffer sb = new StringBuffer();
        sb.append("<p class=\"description\">").append(tutorial.getDescription());
        if (tutorial.getRemoteLink() != null && tutorial.getRemoteLinkLabel() != null) {
            sb.append("<br><br><a href=\"").append(tutorial.getRemoteLink()).append("\" target=\"_blank\">").append(tutorial.getRemoteLinkLabel()).append("</a>");
        }
        sb.append("</p>");
        UIUtils.setHtml(description, sb.toString(), ".description { margin: 10px;}");
        contents.add((Component)description, c);
        ++c.gridy;
        c.insets = JBUI.insets((int)0, (int)5, (int)5, (int)5);
        int numericLabel = 1;
        for (StepData stepData : tutorial.getSteps()) {
            TutorialStep stepDisplay = new TutorialStep(stepData, numericLabel, listener, project);
            contents.add((Component)stepDisplay, c);
            ++c.gridy;
            ++numericLabel;
        }
        GridBagConstraints glueConstraints = UIUtils.getVerticalGlueConstraints(c.gridy);
        contents.add(Box.createVerticalGlue(), glueConstraints);
        ++c.gridy;
        if (!hideChooserAndNavigationalBar) {
            c.insets = JBUI.emptyInsets();
            contents.add((Component)new FooterNav(), c);
        }
        this.myContentsScroller.getVerticalScrollBar().setUnitIncrement(16);
        this.myContentsScroller.setViewportView((Component)contents);
        this.myContentsScroller.setBorder((Border)BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
        this.myContentsScroller.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myContentsScroller.setOpaque(false);
        this.myContentsScroller.getViewport().setOpaque(false);
        this.myContentsScroller.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.myContentsScroller, "Center");
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        JScrollBar verticalScrollBar = this.myContentsScroller.getVerticalScrollBar();
        JScrollBar horizontalScrollBar = this.myContentsScroller.getHorizontalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMinimum());
        horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
    }

    private class BackButton
    extends NavigationButton {
        public BackButton(String label) {
            super(label, "studio_tutorial_chooser", TutorialCard.this.myListener);
            this.setIcon(AllIcons.Actions.Back);
            this.setHorizontalTextPosition(4);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setBorder(null);
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(12));
            Font font = new JBLabel().getFont();
            this.setFont(new Font(font.getFontName(), 0, font.getSize()));
        }
    }

    private class FooterNav
    extends JPanel {
        private final String BACK_LABEL;

        FooterNav() {
            super(new FlowLayout(3));
            this.BACK_LABEL = "Back to " + TutorialCard.this.myTutorialsTitle;
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
            this.setOpaque(false);
            this.add(new BackButton(this.BACK_LABEL));
        }
    }

    private class HeaderNav
    extends JPanel {
        public final String ROOT_TITLE;

        HeaderNav(String location, ActionListener listener) {
            super((LayoutManager)new HorizontalLayout(5, 0));
            this.ROOT_TITLE = "<html><b>" + TutorialCard.this.myTutorialsTitle + "</b> &nbsp;&rsaquo;</html>";
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add(new BackButton(this.ROOT_TITLE));
            JBLabel label = new JBLabel(location);
            label.setForeground(UIUtils.getSecondaryColor());
            this.add((Component)label);
        }
    }

    private static class TutorialDescription
    extends JTextPane {
        TutorialDescription() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIUtils.getSeparatorColor()));
        }
    }
}

