/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingClassFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;

    public DataBindingClassFinder(DataBindingProjectComponent component) {
        this.myComponent = component;
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/databinding/DataBindingClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingClassFinder", "findClass"));
        }
        if (!this.isEnabled()) {
            return null;
        }
        for (AndroidFacet facet : this.myComponent.getDataBindingEnabledFacets()) {
            VirtualFile file;
            DataBindingInfo dataBindingInfo;
            LocalResourceRepository moduleResources = facet.getModuleResources(true);
            Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
            if (dataBindingResourceFiles == null || (dataBindingInfo = dataBindingResourceFiles.get(qualifiedName)) == null || (file = dataBindingInfo.getPsiFile().getVirtualFile()) == null || !scope.accept(file)) continue;
            return DataBindingUtil.getOrCreatePsiClass(dataBindingInfo);
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/databinding/DataBindingClassFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingClassFinder", "findClasses"));
        }
        if (!this.isEnabled()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingClassFinder", "findClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass aClass = this.findClass(qualifiedName, scope);
        if (aClass == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingClassFinder", "findClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = new PsiClass[]{aClass};
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingClassFinder", "findClasses"));
        }
        return psiClassArray;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/databinding/DataBindingClassFinder", "findPackage"));
        }
        return null;
    }

    private boolean isEnabled() {
        return DataBindingUtil.inMemoryClassGenerationIsEnabled() && this.myComponent.hasAnyDataBindingEnabledFacet();
    }
}

