/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.Lists;
import com.intellij.ProjectTopics;
import com.intellij.codeEditor.JavaEditorFileSwapper;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachAndroidSdkSourcesNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"add sdk sources to class");
    private final Project myProject;

    public AttachAndroidSdkSourcesNotificationProvider(@NotNull Project project, final @NotNull EditorNotifications notifications) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider", "<init>"));
        }
        if (notifications == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notifications", "com/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider", "<init>"));
        }
        this.myProject = project;
        this.myProject.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                notifications.updateAllNotifications();
            }
        });
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider", "createNotificationPanel"));
        }
        if (file.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        if (JavaEditorFileSwapper.findSourceFile((Project)this.myProject, (VirtualFile)file) == null) {
            JdkOrderEntry jdkOrderEntry = this.findAndroidSdkEntryForFile(file);
            if (jdkOrderEntry == null) {
                return null;
            }
            Sdk sdk = jdkOrderEntry.getJdk();
            String sdkHome = sdk.getHomePath();
            if (sdkHome == null) {
                return null;
            }
            if (sdk.getRootProvider().getFiles(OrderRootType.SOURCES).length > 0) {
                return null;
            }
            AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
            if (platform == null) {
                return null;
            }
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText("Sources for '" + jdkOrderEntry.getJdkName() + "' not found.");
            panel.createActionLabel("Download", () -> {
                ArrayList requested = Lists.newArrayList();
                requested.add(DetailsTypes.getSourcesPath((AndroidVersion)platform.getApiVersion()));
                ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(this.myProject, requested);
                if (dialog != null && dialog.showAndGet()) {
                    AndroidSdkUtils.updateSdkSourceRoot(sdk);
                }
            });
            panel.createActionLabel("Refresh (if already downloaded)", () -> AndroidSdkUtils.updateSdkSourceRoot(sdk));
            return panel;
        }
        return null;
    }

    @Nullable
    private JdkOrderEntry findAndroidSdkEntryForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider", "findAndroidSdkEntryForFile"));
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        for (OrderEntry entry : index.getOrderEntriesForFile(file)) {
            if (!(entry instanceof JdkOrderEntry)) continue;
            JdkOrderEntry jdkOrderEntry = (JdkOrderEntry)entry;
            if (!AndroidSdks.getInstance().isAndroidSdk(jdkOrderEntry.getJdk())) continue;
            return jdkOrderEntry;
        }
        return null;
    }
}

