/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.rendering.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceData {
    private final AndroidFacet myFacet;
    private final Map<String, StringResource> myKeyToResourceMap;

    public StringResourceData(@NotNull AndroidFacet facet, @NotNull Map<String, StringResource> keyToResourceMap) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/strings/StringResourceData", "<init>"));
        }
        if (keyToResourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyToResourceMap", "com/android/tools/idea/editors/strings/StringResourceData", "<init>"));
        }
        this.myFacet = facet;
        this.myKeyToResourceMap = keyToResourceMap;
    }

    public void changeKeyName(@NotNull String oldKey, @NotNull String newKey) {
        if (oldKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldKey", "com/android/tools/idea/editors/strings/StringResourceData", "changeKeyName"));
        }
        if (newKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newKey", "com/android/tools/idea/editors/strings/StringResourceData", "changeKeyName"));
        }
        Set<String> keys = this.myKeyToResourceMap.keySet();
        if (!keys.contains(oldKey)) {
            throw new IllegalArgumentException("The old key \"" + oldKey + "\" doesn't exist.");
        }
        if (keys.contains(newKey)) {
            throw new IllegalArgumentException("The new key \"" + newKey + "\" already exists.");
        }
        StringResource stringResource = this.myKeyToResourceMap.remove(oldKey);
        assert (stringResource != null);
        stringResource.setKey(newKey);
        this.myKeyToResourceMap.put(newKey, stringResource);
    }

    public boolean setTranslatable(String key, boolean translatable) {
        StringResource stringResource = this.getStringResource(key);
        ResourceItem item = stringResource.getDefaultValueAsResourceItem();
        if (item != null) {
            String translatableAsString;
            if (translatable) {
                translatableAsString = null;
                stringResource.setTranslatable(true);
            } else {
                translatableAsString = "false";
                stringResource.setTranslatable(false);
            }
            return StringsWriteUtils.setAttributeForItems(this.myFacet.getModule().getProject(), "translatable", translatableAsString, Collections.singletonList(item));
        }
        return false;
    }

    public boolean setTranslation(@NotNull String key, @Nullable Locale locale, @NotNull String value) {
        ResourceItem currentItem;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "setTranslation"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/strings/StringResourceData", "setTranslation"));
        }
        StringResource stringResource = this.getStringResource(key);
        ResourceItem resourceItem = currentItem = locale == null ? stringResource.getDefaultValueAsResourceItem() : stringResource.getTranslationAsResourceItem(locale);
        if (currentItem != null) {
            String oldText;
            String string = oldText = locale == null ? stringResource.getDefaultValueAsString() : stringResource.getTranslationAsString(locale);
            if (!StringUtil.equals((CharSequence)oldText, (CharSequence)value)) {
                boolean changed = StringsWriteUtils.setItemText(this.myFacet.getModule().getProject(), currentItem, value);
                if (changed) {
                    if (value.isEmpty()) {
                        if (locale == null) {
                            stringResource.removeDefaultValue();
                        } else {
                            stringResource.removeTranslation(locale);
                        }
                    } else if (locale == null) {
                        stringResource.setDefaultValue(currentItem, value);
                    } else {
                        stringResource.putTranslation(locale, currentItem, value);
                    }
                }
                return changed;
            }
        } else {
            VirtualFile primaryResourceDir = this.myFacet.getPrimaryResourceDir();
            assert (primaryResourceDir != null);
            boolean translatable = stringResource.isTranslatable();
            ResourceItem item = StringsWriteUtils.createItem(this.myFacet, primaryResourceDir, locale, key, value, translatable);
            if (item != null) {
                if (locale == null) {
                    stringResource.setDefaultValue(item, value);
                } else {
                    stringResource.putTranslation(locale, item, value);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Nullable
    public String validateKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "validateKey"));
        }
        if (!this.myKeyToResourceMap.keySet().contains(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        StringResource stringResource = this.getStringResource(key);
        if (!stringResource.isTranslatable()) {
            Collection<Locale> localesWithTranslation = stringResource.getTranslatedLocales();
            if (!localesWithTranslation.isEmpty()) {
                return String.format("Key '%1$s' is marked as non translatable, but is translated in %2$s %3$s", key, StringUtil.pluralize((String)"locale", (int)localesWithTranslation.size()), StringResourceData.summarizeLocales(localesWithTranslation));
            }
        } else {
            if (stringResource.getDefaultValueAsResourceItem() == null) {
                return "Key '" + key + "' missing default value";
            }
            Collection<Locale> missingTranslations = this.getMissingTranslations(key);
            if (!missingTranslations.isEmpty()) {
                return String.format("Key '%1$s' has translations missing for %2$s %3$s", key, StringUtil.pluralize((String)"locale", (int)missingTranslations.size()), StringResourceData.summarizeLocales(missingTranslations));
            }
        }
        return null;
    }

    @Nullable
    public String validateTranslation(@NotNull String key, @Nullable Locale locale) {
        boolean doNotTranslate;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "validateTranslation"));
        }
        if (!this.myKeyToResourceMap.keySet().contains(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        StringResource stringResource = this.getStringResource(key);
        if (locale == null) {
            ResourceItem item = stringResource.getDefaultValueAsResourceItem();
            return item == null ? String.format("Key '%1$s' is missing the default value", key) : null;
        }
        boolean translationMissing = stringResource.isTranslationMissing(locale);
        boolean bl = doNotTranslate = !stringResource.isTranslatable();
        if (translationMissing && !doNotTranslate) {
            return String.format("Key '%1$s' is missing %2$s translation", key, StringResourceData.getLabel(locale));
        }
        if (doNotTranslate && !translationMissing) {
            return "Key '" + key + "' is marked as untranslatable and should not be translated to " + StringResourceData.getLabel(locale);
        }
        return null;
    }

    @NotNull
    @VisibleForTesting
    Collection<Locale> getMissingTranslations(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "getMissingTranslations"));
        }
        HashSet missingTranslations = Sets.newHashSet();
        for (Locale locale : this.getLocales()) {
            StringResource stringResource = this.getStringResource(key);
            if (!stringResource.isTranslationMissing(locale)) continue;
            missingTranslations.add(locale);
        }
        HashSet hashSet = missingTranslations;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getMissingTranslations"));
        }
        return hashSet;
    }

    @VisibleForTesting
    @NotNull
    static String summarizeLocales(@NotNull Collection<Locale> locales) {
        if (locales == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locales", "com/android/tools/idea/editors/strings/StringResourceData", "summarizeLocales"));
        }
        if (locales.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "summarizeLocales"));
            }
            return "";
        }
        int size = locales.size();
        if (size == 1) {
            String string = StringResourceData.getLabel((Locale)Iterables.getFirst(locales, null));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "summarizeLocales"));
            }
            return string;
        }
        int max = 3;
        List<Locale> sorted = StringResourceData.getLowest(locales, 3);
        if (size <= 3) {
            String string = StringResourceData.getLabels(sorted.subList(0, size - 1)) + " and " + StringResourceData.getLabel(sorted.get(size - 1));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "summarizeLocales"));
            }
            return string;
        }
        String string = String.format("%1$s and %2$d more", StringResourceData.getLabels(sorted), size - 3);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "summarizeLocales"));
        }
        return string;
    }

    private static List<Locale> getLowest(Collection<Locale> locales, int n) {
        return locales.stream().limit(n).sorted((locale1, locale2) -> StringResourceData.getLabel(locale1).compareTo(StringResourceData.getLabel(locale2))).collect(Collectors.toList());
    }

    private static String getLabels(Collection<Locale> locales) {
        return locales.stream().map(StringResourceData::getLabel).collect(Collectors.joining(", "));
    }

    private static String getLabel(@Nullable Locale locale) {
        return locale == null ? "" : LocaleMenuAction.getLocaleLabel(locale, false);
    }

    boolean containsKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "containsKey"));
        }
        return this.myKeyToResourceMap.containsKey(key);
    }

    @NotNull
    public StringResource getStringResource(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "getStringResource"));
        }
        StringResource stringResource = this.myKeyToResourceMap.get(key);
        if (stringResource != null) {
            StringResource stringResource2 = stringResource;
            if (stringResource2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getStringResource"));
            }
            return stringResource2;
        }
        throw new IllegalArgumentException("No StringResource for key " + key);
    }

    @NotNull
    public Collection<StringResource> getResources() {
        Collection<StringResource> collection = this.myKeyToResourceMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getResources"));
        }
        return collection;
    }

    @NotNull
    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.myKeyToResourceMap.keySet());
        Collections.sort(keys);
        ArrayList<String> arrayList = keys;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getKeys"));
        }
        return arrayList;
    }

    @NotNull
    public List<Locale> getLocales() {
        TreeSet<Locale> locales = new TreeSet<Locale>(Locale.LANGUAGE_CODE_COMPARATOR);
        for (StringResource stringResource : this.myKeyToResourceMap.values()) {
            locales.addAll(stringResource.getTranslatedLocales());
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>(locales);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getLocales"));
        }
        return arrayList;
    }
}

