/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "getInstance"));
        }
        GradleDependencyManager gradleDependencyManager = (GradleDependencyManager)ServiceManager.getService((Project)project, GradleDependencyManager.class);
        if (gradleDependencyManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "getInstance"));
        }
        return gradleDependencyManager;
    }

    public boolean dependsOn(@NotNull Module module, @NotNull String artifact) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "dependsOn"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "dependsOn"));
        }
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        return gradleModel != null && GradleUtil.dependsOn(gradleModel, artifact);
    }

    @NotNull
    public List<GradleCoordinate> findMissingDependencies(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "findMissingDependencies"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "findMissingDependencies"));
        }
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (gradleModel == null && buildModel == null) {
            List<GradleCoordinate> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "findMissingDependencies"));
            }
            return list;
        }
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        ArrayList missingLibraries = Lists.newArrayList();
        for (GradleCoordinate coordinate : dependencies) {
            GradleCoordinate resolvedCoordinate = manager.resolveDynamicCoordinate(coordinate, null);
            if (resolvedCoordinate == null) {
                if (coordinate.getArtifactId() == null || coordinate.getGroupId() == null) {
                    continue;
                }
            } else {
                coordinate = resolvedCoordinate;
            }
            boolean dependencyFound = false;
            if (gradleModel != null && GradleUtil.dependsOn(gradleModel, String.format("%s:%s", coordinate.getGroupId(), coordinate.getArtifactId()))) {
                dependencyFound = true;
            } else if (buildModel != null) {
                for (ArtifactDependencyModel dependency : buildModel.dependencies().artifacts("compile")) {
                    if (!Objects.equal((Object)coordinate.getGroupId(), dependency.group().value()) || !Objects.equal((Object)coordinate.getArtifactId(), (Object)dependency.name().value())) continue;
                    dependencyFound = true;
                    break;
                }
            }
            if (dependencyFound) continue;
            missingLibraries.add(coordinate);
        }
        ArrayList arrayList = missingLibraries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "findMissingDependencies"));
        }
        return arrayList;
    }

    public boolean ensureLibraryIsIncluded(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies, @Nullable Runnable callback) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "ensureLibraryIsIncluded"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "ensureLibraryIsIncluded"));
        }
        List<GradleCoordinate> missing = this.findMissingDependencies(module, dependencies);
        if (missing.isEmpty()) {
            return true;
        }
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return false;
        }
        if (GradleDependencyManager.userWantToAddDependencies(module, missing)) {
            GradleDependencyManager.addDependenciesInTransaction(buildModel, module, missing, callback);
            return true;
        }
        return false;
    }

    public boolean updateLibrariesToVersion(@NotNull Module module, @NotNull List<GradleCoordinate> dependencies, @Nullable Runnable callback) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "updateLibrariesToVersion"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "updateLibrariesToVersion"));
        }
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return false;
        }
        GradleDependencyManager.updateDependenciesInTransaction(buildModel, module, dependencies, callback);
        return true;
    }

    private static boolean userWantToAddDependencies(@NotNull Module module, @NotNull Collection<GradleCoordinate> missing) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "userWantToAddDependencies"));
        }
        if (missing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missing", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "userWantToAddDependencies"));
        }
        String libraryNames = StringUtil.join(missing, GradleCoordinate::getArtifactId, (String)", ");
        String message = String.format("This operation requires the %1$s %2$s. \n\nWould you like to add %3$s %1$s now?", StringUtil.pluralize((String)"library", (int)missing.size()), libraryNames, StringUtil.pluralize((String)"this", (int)missing.size()));
        Project project = module.getProject();
        return Messages.showOkCancelDialog((Project)project, (String)message, (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    private static void addDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback) {
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependenciesInTransaction"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependenciesInTransaction"));
        }
        if (coordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependenciesInTransaction"));
        }
        assert (!coordinates.isEmpty());
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$1", "run"));
                }
                GradleDependencyManager.addDependencies(buildModel, module, coordinates);
                GradleDependencyManager.requestProjectSync(project, callback);
            }
        }.execute();
    }

    private static void addDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates) {
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependencies"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependencies"));
        }
        if (coordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependencies"));
        }
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            if (buildModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "lambda$addDependencies$0"));
            }
            if (coordinates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "lambda$addDependencies$0"));
            }
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate coordinate : coordinates) {
                dependenciesModel.addArtifact("compile", coordinate.toString());
            }
            buildModel.applyChanges();
        });
    }

    private static void updateDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback) {
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "updateDependenciesInTransaction"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "updateDependenciesInTransaction"));
        }
        if (coordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "updateDependenciesInTransaction"));
        }
        assert (!coordinates.isEmpty());
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$2", "run"));
                }
                GradleDependencyManager.updateDependencies(buildModel, module, coordinates);
                GradleDependencyManager.requestProjectSync(project, callback);
            }
        }.execute();
    }

    private static void requestProjectSync(@NotNull Project project, @Nullable Runnable callback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "requestProjectSync"));
        }
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setGenerateSourcesOnSuccess(true);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request, GradleDependencyManager.createSyncListener(callback));
    }

    private static void updateDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates) {
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "updateDependencies"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "updateDependencies"));
        }
        if (coordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "updateDependencies"));
        }
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            if (buildModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "lambda$updateDependencies$1"));
            }
            if (coordinates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "lambda$updateDependencies$1"));
            }
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate gc : coordinates) {
                ArrayList artifacts = Lists.newArrayList(dependenciesModel.artifacts());
                for (ArtifactDependencyModel m : artifacts) {
                    if (gc.getGroupId() == null || !gc.getGroupId().equals(m.group().value()) || gc.getArtifactId() == null || !gc.getArtifactId().equals(m.name().value()) || gc.getRevision().equals(m.version().value())) continue;
                    dependenciesModel.remove(m);
                    dependenciesModel.addArtifact(m.configurationName(), gc.toString());
                }
            }
            buildModel.applyChanges();
        });
    }

    @Nullable
    private static GradleSyncListener createSyncListener(final @Nullable Runnable callback) {
        if (callback == null) {
            return null;
        }
        return new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$3", "syncSucceeded"));
                }
                callback.run();
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$3", "syncSkipped"));
                }
                callback.run();
            }
        };
    }
}

