/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FileDependencyModel
extends DependencyModel {
    @NonNls
    private static final String FILES = "files";
    @NotNull
    private String myConfigurationName;
    @NotNull
    private final GradleDslExpression myFileDslExpression;

    static Collection<? extends FileDependencyModel> create(@NotNull String configurationName, @NotNull GradleDslMethodCall methodCall) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "create"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "create"));
        }
        ArrayList<FileDependencyModel> result = new ArrayList<FileDependencyModel>();
        if (FILES.equals(methodCall.getName())) {
            List<GradleDslElement> arguments = methodCall.getArguments();
            for (GradleDslElement argument : arguments) {
                if (!(argument instanceof GradleDslExpression)) continue;
                result.add(new FileDependencyModel(configurationName, (GradleDslExpression)argument));
            }
        }
        return result;
    }

    static void createAndAddToList(@NotNull GradleDslElementList list, @NotNull String configurationName, @NotNull String file) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "createAndAddToList"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "createAndAddToList"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "createAndAddToList"));
        }
        String methodName = FILES;
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)list, methodName, configurationName);
        GradleDslLiteral fileDslLiteral = new GradleDslLiteral(methodCall, methodName);
        fileDslLiteral.setValue(file);
        methodCall.addNewArgument(fileDslLiteral);
        list.addNewElement(methodCall);
    }

    private FileDependencyModel(@NotNull String configurationName, @NotNull GradleDslExpression fileDslExpression) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "<init>"));
        }
        if (fileDslExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDslExpression", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "<init>"));
        }
        this.myConfigurationName = configurationName;
        this.myFileDslExpression = fileDslExpression;
    }

    @Override
    @NotNull
    protected GradleDslElement getDslElement() {
        GradleDslExpression gradleDslExpression = this.myFileDslExpression;
        if (gradleDslExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "getDslElement"));
        }
        return gradleDslExpression;
    }

    @Override
    @NotNull
    public String configurationName() {
        String string = this.myConfigurationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "configurationName"));
        }
        return string;
    }

    @NotNull
    public GradleNotNullValue<String> file() {
        String file = this.myFileDslExpression.getValue(String.class);
        assert (file != null);
        GradleNotNullValue<String> gradleNotNullValue = new GradleNotNullValue<String>(this.myFileDslExpression, file);
        if (gradleNotNullValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "file"));
        }
        return gradleNotNullValue;
    }

    public void setFile(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/dependencies/FileDependencyModel", "setFile"));
        }
        this.myFileDslExpression.setValue(file);
    }
}

