/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildStopper {
    @NotNull
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myMap = new ConcurrentHashMap<ExternalSystemTaskId, CancellationTokenSource>();

    BuildStopper() {
    }

    @NotNull
    CancellationTokenSource createAndRegisterTokenSource(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/gradle/project/build/invoker/BuildStopper", "createAndRegisterTokenSource"));
        }
        CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();
        this.myMap.put(id, tokenSource);
        CancellationTokenSource cancellationTokenSource = tokenSource;
        if (cancellationTokenSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/BuildStopper", "createAndRegisterTokenSource"));
        }
        return cancellationTokenSource;
    }

    void register(@NotNull ExternalSystemTaskId id, CancellationTokenSource tokenSource) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/gradle/project/build/invoker/BuildStopper", "register"));
        }
        this.myMap.put(id, tokenSource);
    }

    void attemptToStopBuild(@NotNull ExternalSystemTaskId id, @Nullable ProgressIndicator progressIndicator) {
        CancellationTokenSource token;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/gradle/project/build/invoker/BuildStopper", "attemptToStopBuild"));
        }
        if (progressIndicator != null) {
            if (progressIndicator.isCanceled()) {
                return;
            }
            if (progressIndicator.isRunning()) {
                progressIndicator.setText("Stopping Gradle build...");
                progressIndicator.cancel();
            }
        }
        if ((token = this.remove(id)) != null) {
            token.cancel();
        }
    }

    @Nullable
    CancellationTokenSource remove(@NotNull ExternalSystemTaskId taskId) {
        if (taskId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskId", "com/android/tools/idea/gradle/project/build/invoker/BuildStopper", "remove"));
        }
        return this.myMap.remove(taskId);
    }

    boolean contains(@NotNull ExternalSystemTaskId taskId) {
        if (taskId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskId", "com/android/tools/idea/gradle/project/build/invoker/BuildStopper", "contains"));
        }
        return this.myMap.containsKey(taskId);
    }

    @Nullable
    CancellationTokenSource get(@NotNull ExternalSystemTaskId taskId) {
        if (taskId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskId", "com/android/tools/idea/gradle/project/build/invoker/BuildStopper", "get"));
        }
        return this.myMap.get(taskId);
    }
}

