/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.ide.common.blame.Message;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleInvocationResult {
    @NotNull
    private final List<String> myTasks;
    @NotNull
    private final ListMultimap<Message.Kind, Message> myCompilerMessagesByKind;
    private final boolean myBuildSuccessful;

    GradleInvocationResult(@NotNull List<String> tasks, @NotNull List<Message> compilerMessages, boolean buildSuccessful) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/project/build/invoker/GradleInvocationResult", "<init>"));
        }
        if (compilerMessages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerMessages", "com/android/tools/idea/gradle/project/build/invoker/GradleInvocationResult", "<init>"));
        }
        this.myCompilerMessagesByKind = ArrayListMultimap.create();
        this.myTasks = tasks;
        this.myBuildSuccessful = buildSuccessful;
        for (Message msg : compilerMessages) {
            this.myCompilerMessagesByKind.put((Object)msg.getKind(), (Object)msg);
        }
    }

    @NotNull
    public List<String> getTasks() {
        List<String> list = this.myTasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleInvocationResult", "getTasks"));
        }
        return list;
    }

    @NotNull
    public List<Message> getCompilerMessages(@NotNull Message.Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/android/tools/idea/gradle/project/build/invoker/GradleInvocationResult", "getCompilerMessages"));
        }
        List list = this.myCompilerMessagesByKind.get((Object)kind);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleInvocationResult", "getCompilerMessages"));
        }
        return list;
    }

    public boolean isBuildSuccessful() {
        return this.myBuildSuccessful;
    }
}

