/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.facet.ndk;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetType;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkFacet
extends Facet<NdkFacetConfiguration> {
    @NotNull
    private static final FacetTypeId<NdkFacet> TYPE_ID = new FacetTypeId("native-android-gradle");
    private NdkModuleModel myNdkModuleModel;

    @Nullable
    public static NdkFacet getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/facet/ndk/NdkFacet", "getInstance"));
        }
        return (NdkFacet)FacetManager.getInstance((Module)module).getFacetByType(TYPE_ID);
    }

    public NdkFacet(@NotNull Module module, @NotNull String name, @NotNull NdkFacetConfiguration configuration) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/facet/ndk/NdkFacet", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/facet/ndk/NdkFacet", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/gradle/project/facet/ndk/NdkFacet", "<init>"));
        }
        super((FacetType)NdkFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
    }

    @NotNull
    public static NdkFacetType getFacetType() {
        FacetType facetType = FacetTypeRegistry.getInstance().findFacetType(NdkFacet.getFacetId());
        assert (facetType instanceof NdkFacetType);
        NdkFacetType ndkFacetType = (NdkFacetType)facetType;
        if (ndkFacetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/facet/ndk/NdkFacet", "getFacetType"));
        }
        return ndkFacetType;
    }

    @NotNull
    public static FacetTypeId<NdkFacet> getFacetTypeId() {
        FacetTypeId<NdkFacet> facetTypeId = TYPE_ID;
        if (facetTypeId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/facet/ndk/NdkFacet", "getFacetTypeId"));
        }
        return facetTypeId;
    }

    @NotNull
    public static String getFacetId() {
        if ("native-android-gradle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/facet/ndk/NdkFacet", "getFacetId"));
        }
        return "native-android-gradle";
    }

    @NotNull
    public static String getFacetName() {
        if ("Native-Android-Gradle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/facet/ndk/NdkFacet", "getFacetName"));
        }
        return "Native-Android-Gradle";
    }

    public void initFacet() {
        MessageBusConnection connection = this.getModule().getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!NdkFacet.this.isDisposed()) {
                        PsiDocumentManager.getInstance((Project)NdkFacet.this.getModule().getProject()).commitAllDocuments();
                        NdkFacet.this.updateConfiguration();
                    }
                });
            }
        });
        this.updateConfiguration();
    }

    private void updateConfiguration() {
        NdkFacetConfiguration config = (NdkFacetConfiguration)this.getConfiguration();
        try {
            FacetUtil.saveFacetConfiguration((FacetConfiguration)config);
        }
        catch (WriteExternalException e) {
            Logger.getInstance(NdkFacet.class).error("Unable to save contents of 'Native-Android-Gradle' facet", (Throwable)e);
        }
    }

    @Nullable
    public NdkModuleModel getNdkModuleModel() {
        return this.myNdkModuleModel;
    }

    public void setNdkModuleModel(@NotNull NdkModuleModel ndkModuleModel) {
        if (ndkModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ndkModuleModel", "com/android/tools/idea/gradle/project/facet/ndk/NdkFacet", "setNdkModuleModel"));
        }
        this.myNdkModuleModel = ndkModuleModel;
        ((NdkFacetConfiguration)this.getConfiguration()).SELECTED_BUILD_VARIANT = this.myNdkModuleModel.getSelectedVariant().getName();
    }
}

