/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class Jdk8RequiredErrorHandler
extends BaseSyncErrorHandler {
    @NotNull
    private final Jdks myJdks;

    public Jdk8RequiredErrorHandler(@NotNull Jdks jdks) {
        if (jdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdks", "com/android/tools/idea/gradle/project/sync/errors/Jdk8RequiredErrorHandler", "<init>"));
        }
        this.myJdks = jdks;
    }

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/Jdk8RequiredErrorHandler", "findErrorMessage"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/Jdk8RequiredErrorHandler", "findErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/Jdk8RequiredErrorHandler", "findErrorMessage"));
        }
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text) && text.contains("Unsupported major.minor version 52.0")) {
            if (!text.endsWith(".")) {
                text = text + ".";
            }
            text = text + " Please use JDK 8 or newer.";
            Jdk8RequiredErrorHandler.updateUsageTracker();
            return text;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/Jdk8RequiredErrorHandler", "getQuickFixHyperlinks"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/Jdk8RequiredErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/Jdk8RequiredErrorHandler", "getQuickFixHyperlinks"));
        }
        List<NotificationHyperlink> list = this.myJdks.getWrongJdkQuickFixes(project);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/Jdk8RequiredErrorHandler", "getQuickFixHyperlinks"));
        }
        return list;
    }
}

