/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.io.Closeables;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MissingAndroidSdkErrorHandler
extends BaseSyncErrorHandler {
    private static final String FIX_SDK_DIR_PROPERTY = "Please fix the 'sdk.dir' property in the local.properties file.";
    private static final String SDK_DIR_PROPERTY_MISSING = "No sdk.dir property defined in local.properties file.";
    private static final Pattern SDK_NOT_FOUND_PATTERN = Pattern.compile("The SDK directory '(.*?)' does not exist.");

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSdkErrorHandler", "findErrorMessage"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSdkErrorHandler", "findErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSdkErrorHandler", "findErrorMessage"));
        }
        String text = rootCause.getMessage();
        if (rootCause instanceof RuntimeException && StringUtil.isNotEmpty((String)text) && (text.equals(SDK_DIR_PROPERTY_MISSING) || SDK_NOT_FOUND_PATTERN.matcher(text).matches())) {
            MissingAndroidSdkErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.SDK_NOT_FOUND);
            File buildProperties = new File(Projects.getBaseDirPath(project), "local.properties");
            if (buildProperties.isFile()) {
                text = text + "\n\nPlease fix the 'sdk.dir' property in the local.properties file.";
                return text;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        int lineNumber;
        File file;
        block16: {
            String line;
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSdkErrorHandler", "getQuickFixHyperlinks"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSdkErrorHandler", "getQuickFixHyperlinks"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSdkErrorHandler", "getQuickFixHyperlinks"));
            }
            file = new File(Projects.getBaseDirPath(project), "local.properties");
            lineNumber = 0;
            BufferedReader reader = null;
            reader = new BufferedReader(new FileReader(file));
            int counter2333333332 = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("sdk.dir")) {
                    lineNumber = counter2333333332;
                    break;
                }
                ++counter2333333332;
            }
            try {
                Closeables.close((Closeable)reader, (boolean)true);
            }
            catch (IOException counter2333333332) {}
            break block16;
            catch (IOException e222222222) {
                try {
                    Logger.getInstance(this.getClass()).info("Unable to read file: " + file.getPath(), (Throwable)e222222222);
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(reader, (boolean)true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException e222222222) {}
            }
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new OpenFileHyperlink(file.getPath(), lineNumber));
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSdkErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }
}

