/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class DataNodeCaches {
    @NotNull
    private final Project myProject;

    @NotNull
    public static DataNodeCaches getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches", "getInstance"));
        }
        DataNodeCaches dataNodeCaches = (DataNodeCaches)ServiceManager.getService((Project)project, DataNodeCaches.class);
        if (dataNodeCaches == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches", "getInstance"));
        }
        return dataNodeCaches;
    }

    public DataNodeCaches(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches", "<init>"));
        }
        this.myProject = project;
    }

    @Nullable
    public DataNode<ProjectData> getCachedProjectData() {
        String projectPath;
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        ExternalProjectInfo projectInfo = dataManager.getExternalProjectData(this.myProject, GradleConstants.SYSTEM_ID, projectPath = Projects.getBaseDirPath(this.myProject).getPath());
        return projectInfo != null ? projectInfo.getExternalProjectStructure() : null;
    }

    public boolean isCacheMissingModels(@NotNull DataNode<ProjectData> cache) {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches", "isCacheMissingModels"));
        }
        Collection moduleDataNodes = ExternalSystemApiUtil.findAll(cache, (Key)ProjectKeys.MODULE);
        if (!moduleDataNodes.isEmpty()) {
            Map<String, DataNode<ModuleData>> moduleDataNodesByName = DataNodeCaches.indexByModuleName(moduleDataNodes);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            for (Module module : moduleManager.getModules()) {
                GradleFacet gradleFacet;
                DataNode<ModuleData> moduleDataNode = moduleDataNodesByName.get(module.getName());
                if (!(moduleDataNode == null ? (gradleFacet = GradleFacet.getInstance(module)) != null : DataNodeCaches.isCacheMissingModels(moduleDataNode, module))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, DataNode<ModuleData>> indexByModuleName(@NotNull Collection<DataNode<ModuleData>> moduleDataNodes) {
        if (moduleDataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDataNodes", "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches", "indexByModuleName"));
        }
        HashMap mapping = Maps.newHashMap();
        for (DataNode<ModuleData> moduleDataNode : moduleDataNodes) {
            ModuleData data = (ModuleData)moduleDataNode.getData();
            mapping.put(data.getExternalName(), moduleDataNode);
        }
        HashMap hashMap = mapping;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches", "indexByModuleName"));
        }
        return hashMap;
    }

    private static boolean isCacheMissingModels(@NotNull DataNode<ModuleData> cache, @NotNull Module module) {
        DataNode ndkModuleModelDataNode;
        NdkFacet ndkFacet;
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches", "isCacheMissingModels"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches", "isCacheMissingModels"));
        }
        GradleFacet gradleFacet = GradleFacet.getInstance(module);
        if (gradleFacet != null) {
            DataNode javaProjectDataNode;
            JavaFacet javaFacet;
            DataNode androidDataNode;
            DataNode gradleDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.GRADLE_MODULE_MODEL);
            if (gradleDataNode == null) {
                return true;
            }
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null ? (androidDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.ANDROID_MODEL)) == null || !ProxyUtil.isValidProxyObject(((AndroidModuleModel)androidDataNode.getData()).getAndroidProject()) : (javaFacet = JavaFacet.getInstance(module)) != null && (javaProjectDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.JAVA_MODULE_MODEL)) == null) {
                return true;
            }
        }
        return (ndkFacet = NdkFacet.getInstance(module)) != null && ((ndkModuleModelDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.NDK_MODEL)) == null || !ProxyUtil.isValidProxyObject(((NdkModuleModel)ndkModuleModelDataNode.getData()).getAndroidProject()));
    }
}

