/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidAtom;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Sets;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesExtractor {
    @NotNull
    public static DependenciesExtractor getInstance() {
        DependenciesExtractor dependenciesExtractor = (DependenciesExtractor)ServiceManager.getService(DependenciesExtractor.class);
        if (dependenciesExtractor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "getInstance"));
        }
        return dependenciesExtractor;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "extractFrom"));
        }
        DependencySet dependencies = new DependencySet();
        GradleVersion modelVersion = androidModel.getModelVersion();
        for (BaseArtifact testArtifact : androidModel.getTestArtifactsInSelectedVariant()) {
            DependenciesExtractor.populate(dependencies, testArtifact, DependencyScope.TEST, modelVersion);
        }
        AndroidArtifact mainArtifact = androidModel.getMainArtifact();
        DependenciesExtractor.populate(dependencies, (BaseArtifact)mainArtifact, DependencyScope.COMPILE, modelVersion);
        DependencySet dependencySet = dependencies;
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "extractFrom"));
        }
        return dependencySet;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull BaseArtifact artifact, @NotNull DependencyScope scope, @Nullable GradleVersion modelVersion) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "extractFrom"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "extractFrom"));
        }
        DependencySet dependencies = new DependencySet();
        DependenciesExtractor.populate(dependencies, artifact, scope, modelVersion);
        DependencySet dependencySet = dependencies;
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "extractFrom"));
        }
        return dependencySet;
    }

    private static void populate(@NotNull DependencySet dependencies, @NotNull BaseArtifact artifact, @NotNull DependencyScope scope, @Nullable GradleVersion modelVersion) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "populate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "populate"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "populate"));
        }
        Dependencies artifactDependencies = GradleUtil.getDependencies(artifact, modelVersion);
        boolean supportsInstantApps = modelVersion != null && GradleUtil.androidModelSupportsInstantApps(modelVersion);
        DependenciesExtractor.addJavaLibraries(dependencies, artifactDependencies.getJavaLibraries(), scope);
        HashSet unique = Sets.newHashSet();
        for (AndroidLibrary library : artifactDependencies.getLibraries()) {
            DependenciesExtractor.addAndroidLibrary(library, dependencies, scope, unique);
        }
        if (supportsInstantApps) {
            Collection atoms = null;
            try {
                atoms = artifactDependencies.getAtoms();
            }
            catch (Throwable e) {
                DependenciesExtractor.getLogger().warn("Android plugin version " + modelVersion.toString() + " should support Atoms", e);
            }
            if (atoms != null) {
                for (AndroidAtom androidAtom : atoms) {
                    DependenciesExtractor.addAndroidAtom(androidAtom, dependencies, scope, unique);
                }
            }
        }
        for (String gradleProjectPath : artifactDependencies.getProjects()) {
            if (gradleProjectPath == null || gradleProjectPath.isEmpty()) continue;
            ModuleDependency dependency = new ModuleDependency(gradleProjectPath, scope);
            dependencies.add(dependency);
        }
    }

    @NotNull
    private static String getBundleName(@NotNull com.android.builder.model.AndroidBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "getBundleName"));
        }
        MavenCoordinates coordinates = bundle.getResolvedCoordinates();
        if (coordinates != null) {
            String string = coordinates.getArtifactId() + "-" + coordinates.getVersion();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "getBundleName"));
            }
            return string;
        }
        File bundleFile = bundle.getBundle();
        String string = FileUtil.getNameWithoutExtension((File)bundleFile);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "getBundleName"));
        }
        return string;
    }

    private static boolean isAlreadySeen(@NotNull com.android.builder.model.AndroidBundle bundle, @NotNull Set<File> unique) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "isAlreadySeen"));
        }
        if (unique == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unique", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "isAlreadySeen"));
        }
        File folder = bundle.getFolder();
        if (unique.contains(folder)) {
            return true;
        }
        unique.add(folder);
        return false;
    }

    private static void addAndroidLibrary(@NotNull AndroidLibrary library, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAndroidLibrary"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAndroidLibrary"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAndroidLibrary"));
        }
        if (unique == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unique", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAndroidLibrary"));
        }
        if (DependenciesExtractor.isAlreadySeen((com.android.builder.model.AndroidBundle)library, unique)) {
            return;
        }
        String gradleProjectPath = library.getProject();
        if (StringUtil.isNotEmpty((String)gradleProjectPath)) {
            ModuleDependency dependency = new ModuleDependency(gradleProjectPath, scope);
            dependency.setBackupDependency(DependenciesExtractor.createLibraryDependencyFromAndroidLibrary(library, scope));
            dependencies.add(dependency);
        } else {
            dependencies.add(DependenciesExtractor.createLibraryDependencyFromAndroidLibrary(library, scope));
        }
        DependenciesExtractor.addBundleTransitiveDependencies((com.android.builder.model.AndroidBundle)library, dependencies, scope, unique);
    }

    private static void addAndroidAtom(@NotNull AndroidAtom atom, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique) {
        if (atom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atom", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAndroidAtom"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAndroidAtom"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAndroidAtom"));
        }
        if (unique == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unique", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAndroidAtom"));
        }
        if (DependenciesExtractor.isAlreadySeen((com.android.builder.model.AndroidBundle)atom, unique)) {
            return;
        }
        String gradleProjectPath = atom.getProject();
        if (StringUtil.isEmpty((String)gradleProjectPath)) {
            DependenciesExtractor.getLogger().error(AndroidBundle.message("android.gradle.dependency.atom.invalid.external", atom.getName()));
        } else {
            dependencies.add(new ModuleDependency(gradleProjectPath, scope));
            DependenciesExtractor.addAtomTransitiveDependencies(atom, dependencies, scope, unique);
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(DependenciesExtractor.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "getLogger"));
        }
        return logger;
    }

    private static void addBundleTransitiveDependencies(@NotNull com.android.builder.model.AndroidBundle bundle, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addBundleTransitiveDependencies"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addBundleTransitiveDependencies"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addBundleTransitiveDependencies"));
        }
        if (unique == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unique", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addBundleTransitiveDependencies"));
        }
        for (AndroidLibrary dependentLibrary : bundle.getLibraryDependencies()) {
            DependenciesExtractor.addAndroidLibrary(dependentLibrary, dependencies, scope, unique);
        }
    }

    private static void addAtomTransitiveDependencies(@NotNull AndroidAtom atom, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique) {
        if (atom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atom", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAtomTransitiveDependencies"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAtomTransitiveDependencies"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAtomTransitiveDependencies"));
        }
        if (unique == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unique", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addAtomTransitiveDependencies"));
        }
        for (AndroidAtom dependentAtom : atom.getAtomDependencies()) {
            DependenciesExtractor.addAndroidAtom(dependentAtom, dependencies, scope, unique);
        }
        DependenciesExtractor.addBundleTransitiveDependencies((com.android.builder.model.AndroidBundle)atom, dependencies, scope, unique);
    }

    @NotNull
    private static LibraryDependency createLibraryDependencyFromAndroidLibrary(@NotNull AndroidLibrary library, @NotNull DependencyScope scope) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "createLibraryDependencyFromAndroidLibrary"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "createLibraryDependencyFromAndroidLibrary"));
        }
        LibraryDependency dependency = new LibraryDependency(library.getBundle(), DependenciesExtractor.getBundleName((com.android.builder.model.AndroidBundle)library), scope);
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getJarFile());
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getResFolder());
        for (File localJar : library.getLocalJars()) {
            dependency.addPath(LibraryDependency.PathType.BINARY, localJar);
        }
        LibraryDependency libraryDependency = dependency;
        if (libraryDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "createLibraryDependencyFromAndroidLibrary"));
        }
        return libraryDependency;
    }

    private static void addJavaLibraries(@NotNull DependencySet dependencies, @NotNull Collection<? extends JavaLibrary> libraries, @NotNull DependencyScope scope) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addJavaLibraries"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addJavaLibraries"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addJavaLibraries"));
        }
        for (JavaLibrary javaLibrary : libraries) {
            DependenciesExtractor.addJavaLibrary(javaLibrary, dependencies, scope);
        }
    }

    private static void addJavaLibrary(@NotNull JavaLibrary library, @NotNull DependencySet dependencies, @NotNull DependencyScope scope) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addJavaLibrary"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addJavaLibrary"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "addJavaLibrary"));
        }
        dependencies.add(DependenciesExtractor.createLibraryDependencyFromJavaLibrary(library, scope));
        DependenciesExtractor.addJavaLibraries(dependencies, library.getDependencies(), scope);
    }

    @NotNull
    private static LibraryDependency createLibraryDependencyFromJavaLibrary(@NotNull JavaLibrary library, @NotNull DependencyScope scope) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "createLibraryDependencyFromJavaLibrary"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "createLibraryDependencyFromJavaLibrary"));
        }
        File jarFilePath = library.getJarFile();
        LibraryDependency libraryDependency = new LibraryDependency(jarFilePath, scope);
        if (libraryDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor", "createLibraryDependencyFromJavaLibrary"));
        }
        return libraryDependency;
    }
}

