/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkSetupStep
extends ProjectSetupStep {
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final Jdks myJdks;

    public ProjectJdkSetupStep() {
        this(IdeSdks.getInstance(), Jdks.getInstance());
    }

    @VisibleForTesting
    ProjectJdkSetupStep(@NotNull IdeSdks ideSdks, @NotNull Jdks jdks) {
        if (ideSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideSdks", "com/android/tools/idea/gradle/project/sync/setup/post/project/ProjectJdkSetupStep", "<init>"));
        }
        if (jdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdks", "com/android/tools/idea/gradle/project/sync/setup/post/project/ProjectJdkSetupStep", "<init>"));
        }
        this.myIdeSdks = ideSdks;
        this.myJdks = jdks;
    }

    @Override
    public void setUpProject(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/project/ProjectJdkSetupStep", "setUpProject"));
        }
        this.doSetUpProject(project, IdeInfo.getInstance().isAndroidStudio());
    }

    @VisibleForTesting
    void doSetUpProject(@NotNull Project project, boolean androidStudio) {
        Sdk projectJdk;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/project/ProjectJdkSetupStep", "doSetUpProject"));
        }
        LanguageLevel javaLangVersion = LanguageLevel.JDK_1_8;
        Sdk ideJdk = projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (androidStudio) {
            ideJdk = this.myIdeSdks.getJdk();
        } else if (projectJdk == null || !this.myJdks.isApplicableJdk(projectJdk, javaLangVersion)) {
            ideJdk = this.myJdks.chooseOrCreateJavaSdk(javaLangVersion);
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            ideJdk = projectJdk;
        }
        if (ideJdk == null) {
            SyncMessage message = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, "Unable to find a JDK");
            message.add(this.myJdks.getWrongJdkQuickFixes(project));
            SyncMessages.getInstance(project).report(message);
            GradleSyncState.getInstance(project).getSummary().setSyncErrorsFound(true);
            return;
        }
        String homePath = ideJdk.getHomePath();
        if (homePath != null) {
            this.myJdks.setJdk(project, ideJdk);
            PostProjectBuildTasksExecutor.getInstance(project).updateJavaLangLevelAfterBuild();
        }
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }
}

