/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EncodingValidationStrategy
extends AndroidProjectValidationStrategy {
    @NotNull
    private final EncodingProjectManager myEncodings;
    @NotNull
    private final Charset myProjectEncoding;
    @NotNull
    private final GradleVersion myOneDotTwoPluginVersion;
    @Nullable
    private String myMismatchingEncoding;

    EncodingValidationStrategy(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/validation/android/EncodingValidationStrategy", "<init>"));
        }
        this(project, EncodingProjectManager.getInstance((Project)project));
    }

    @VisibleForTesting
    EncodingValidationStrategy(@NotNull Project project, @NotNull EncodingProjectManager encodings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/validation/android/EncodingValidationStrategy", "<init>"));
        }
        if (encodings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encodings", "com/android/tools/idea/gradle/project/sync/validation/android/EncodingValidationStrategy", "<init>"));
        }
        super(project);
        this.myEncodings = encodings;
        this.myProjectEncoding = this.myEncodings.getDefaultCharset();
        this.myOneDotTwoPluginVersion = new GradleVersion(1, 2, 0);
    }

    @Override
    void validate(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/validation/android/EncodingValidationStrategy", "validate"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/validation/android/EncodingValidationStrategy", "validate"));
        }
        GradleVersion modelVersion = androidModel.getModelVersion();
        if (modelVersion != null) {
            boolean isOneDotTwoOrNewer = modelVersion.compareIgnoringQualifiers(this.myOneDotTwoPluginVersion) >= 0;
            Charset modelEncoding = null;
            if (isOneDotTwoOrNewer) {
                try {
                    AndroidProject androidProject = androidModel.getAndroidProject();
                    modelEncoding = Charset.forName(androidProject.getJavaCompileOptions().getEncoding());
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    // empty catch block
                }
            }
            if (this.myMismatchingEncoding == null && modelEncoding != null && this.myProjectEncoding.compareTo(modelEncoding) != 0) {
                this.myMismatchingEncoding = modelEncoding.displayName();
            }
        }
    }

    @Override
    void fixAndReportFoundIssues() {
        if (this.myMismatchingEncoding != null) {
            Project project = this.getProject();
            this.myEncodings.setDefaultCharsetName(this.myMismatchingEncoding);
            String line = String.format("The project encoding (%1$s) has been reset to the encoding specified in the Gradle build files (%2$s).", this.myEncodings.getDefaultCharset().displayName(), this.myMismatchingEncoding);
            String[] text = new String[]{line, "Mismatching encodings can lead to serious bugs."};
            SyncMessage message = new SyncMessage("Gradle Sync Issues", MessageType.INFO, text);
            message.add(new OpenUrlHyperlink("http://tools.android.com/knownissues/encoding", "More Info..."));
            SyncMessages.getInstance(project).report(message);
        }
    }

    @VisibleForTesting
    @Nullable
    String getMismatchingEncoding() {
        return this.myMismatchingEncoding;
    }

    @VisibleForTesting
    void setMismatchingEncoding(@Nullable String mismatchingEncoding) {
        this.myMismatchingEncoding = mismatchingEncoding;
    }
}

