/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FoundArtifact
implements Comparable<FoundArtifact> {
    @NotNull
    private final String myRepositoryName;
    @NotNull
    private final String myGroupId;
    @NotNull
    private final String myName;
    @NotNull
    private final List<GradleVersion> myVersions;

    FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name, @NotNull GradleVersion version) {
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        this(repositoryName, groupId, name);
        this.myVersions.add(version);
        this.sortVersionsFromNewestToOldest();
    }

    FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name, @NotNull List<GradleVersion> versions) {
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        if (versions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        this(repositoryName, groupId, name);
        this.myVersions.addAll(versions);
        this.sortVersionsFromNewestToOldest();
    }

    private void sortVersionsFromNewestToOldest() {
        if (this.myVersions.size() > 1) {
            Collections.sort(this.myVersions, Collections.reverseOrder());
        }
    }

    private FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name) {
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "<init>"));
        }
        this.myVersions = Lists.newArrayList();
        this.myRepositoryName = repositoryName;
        this.myGroupId = groupId;
        this.myName = name;
    }

    @NotNull
    public String getRepositoryName() {
        String string = this.myRepositoryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "getRepositoryName"));
        }
        return string;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "getGroupId"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "getName"));
        }
        return string;
    }

    @NotNull
    public List<GradleVersion> getVersions() {
        List<GradleVersion> list = this.myVersions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "getVersions"));
        }
        return list;
    }

    @Override
    public int compareTo(FoundArtifact other) {
        int compare = FoundArtifact.compareRepositoryNames(this.myRepositoryName, other.myRepositoryName);
        if (compare != 0) {
            return compare;
        }
        compare = FoundArtifact.compareGroupIds(this.myGroupId, other.myGroupId);
        if (compare != 0) {
            return compare;
        }
        return this.myName.compareTo(other.myName);
    }

    private static int compareRepositoryNames(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "compareRepositoryNames"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "compareRepositoryNames"));
        }
        if (s1.equals(s2)) {
            return 0;
        }
        if (s1.equals("Android Repository")) {
            return -1;
        }
        if (s1.equals("Google Repository") && !s2.equals("Android Repository")) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    private static int compareGroupIds(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "compareGroupIds"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "compareGroupIds"));
        }
        if (s1.equals(s2)) {
            return 0;
        }
        String androidPackage = "com.android";
        if (s1.startsWith(androidPackage)) {
            if (s2.startsWith(androidPackage)) {
                return s1.compareTo(s2);
            }
            return -1;
        }
        String googlePackage = "com.google";
        if (s1.startsWith(googlePackage)) {
            if (s2.startsWith(googlePackage)) {
                return s1.compareTo(s2);
            }
            if (!s2.startsWith(androidPackage)) {
                return -1;
            }
        }
        return s1.compareTo(s2);
    }

    @NotNull
    public List<String> getCoordinates() {
        String groupIdAndName = this.myGroupId + ":" + this.myName;
        List<String> list = this.myVersions.stream().map(version -> groupIdAndName + ":" + version).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact", "getCoordinates"));
        }
        return list;
    }

    public String toString() {
        return "{repository='" + this.myRepositoryName + '\'' + ", group='" + this.myGroupId + '\'' + ", name='" + this.myName + '\'' + ", versions=" + this.myVersions + '}';
    }
}

