/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class GradleVersions {
    private static final Pattern GRADLE_JAR_NAME_PATTERN = Pattern.compile("gradle-core-(.*)\\.jar");
    @NotNull
    private final GradleProjectSettingsFinder mySettingsFinder;

    @NotNull
    public static GradleVersions getInstance() {
        GradleVersions gradleVersions = (GradleVersions)ServiceManager.getService(GradleVersions.class);
        if (gradleVersions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleVersions", "getInstance"));
        }
        return gradleVersions;
    }

    public GradleVersions(@NotNull GradleProjectSettingsFinder settingsFinder) {
        if (settingsFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsFinder", "com/android/tools/idea/gradle/util/GradleVersions", "<init>"));
        }
        this.mySettingsFinder = settingsFinder;
    }

    @Nullable
    public GradleVersion getGradleVersion(@NotNull Project project) {
        GradleVersion revision;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleVersions", "getGradleVersion"));
        }
        GradleVersion gradleVersion = GradleSyncState.getInstance(project).getSummary().getGradleVersion();
        if (gradleVersion != null && (revision = GradleVersion.tryParse((String)GradleVersions.removeTimestampFromGradleVersion(gradleVersion.toString()))) != null) {
            return revision;
        }
        GradleProjectSettings gradleSettings = this.mySettingsFinder.findGradleProjectSettings(project);
        if (gradleSettings != null) {
            String gradleHome;
            DistributionType distributionType = gradleSettings.getDistributionType();
            if (distributionType == DistributionType.DEFAULT_WRAPPED) {
                GradleWrapper gradleWrapper = GradleWrapper.find(project);
                if (gradleWrapper != null) {
                    try {
                        String wrapperVersion = gradleWrapper.getGradleVersion();
                        if (wrapperVersion != null) {
                            return GradleVersion.tryParse((String)GradleVersions.removeTimestampFromGradleVersion(wrapperVersion));
                        }
                    }
                    catch (IOException e) {
                        Logger.getInstance(this.getClass()).info("Failed to read Gradle version in wrapper", (Throwable)e);
                    }
                }
            } else if (distributionType == DistributionType.LOCAL && StringUtil.isNotEmpty((String)(gradleHome = gradleSettings.getGradleHome()))) {
                File gradleHomePath = new File(gradleHome);
                return this.getGradleVersion(gradleHomePath);
            }
        }
        return null;
    }

    @Nullable
    public GradleVersion getGradleVersion(@NotNull File gradleHomePath) {
        if (gradleHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleHomePath", "com/android/tools/idea/gradle/util/GradleVersions", "getGradleVersion"));
        }
        File libFolderPath = new File(gradleHomePath, "lib");
        if (libFolderPath.isDirectory()) {
            for (File child : FileUtil.notNullize((File[])libFolderPath.listFiles())) {
                GradleVersion version = GradleVersions.getGradleVersionFromJar(child);
                if (version == null) continue;
                return version;
            }
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static GradleVersion getGradleVersionFromJar(@NotNull File libraryJarFile) {
        if (libraryJarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryJarFile", "com/android/tools/idea/gradle/util/GradleVersions", "getGradleVersionFromJar"));
        }
        String fileName = libraryJarFile.getName();
        Matcher matcher = GRADLE_JAR_NAME_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            String version = matcher.group(1);
            return GradleVersion.tryParse((String)GradleVersions.removeTimestampFromGradleVersion(version));
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    public static String removeTimestampFromGradleVersion(@NotNull String gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleVersions", "removeTimestampFromGradleVersion"));
        }
        int dashIndex = gradleVersion.indexOf(45);
        if (dashIndex != -1) {
            String string = gradleVersion.substring(0, dashIndex);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleVersions", "removeTimestampFromGradleVersion"));
            }
            return string;
        }
        String string = gradleVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleVersions", "removeTimestampFromGradleVersion"));
        }
        return string;
    }
}

