/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import java.text.Collator;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleTypeComparator
implements Comparator<Module> {
    public static final ModuleTypeComparator INSTANCE = new ModuleTypeComparator();

    @Override
    public int compare(Module m1, Module m2) {
        AndroidModuleModel gm1 = AndroidModuleModel.get(m1);
        AndroidModuleModel gm2 = AndroidModuleModel.get(m2);
        return ModuleTypeComparator.compareModules(m1, m2, gm1, gm2);
    }

    @VisibleForTesting
    static int compareModules(@NotNull Module m1, @NotNull Module m2, @Nullable AndroidModuleModel gm1, @Nullable AndroidModuleModel gm2) {
        if (m1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m1", "com/android/tools/idea/gradle/util/ModuleTypeComparator", "compareModules"));
        }
        if (m2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m2", "com/android/tools/idea/gradle/util/ModuleTypeComparator", "compareModules"));
        }
        if (gm1 == null && gm2 == null || gm1 != null && gm2 != null && gm1.getProjectType() == gm2.getProjectType()) {
            return Collator.getInstance().compare(m1.getName(), m2.getName());
        }
        if (gm1 != null) {
            if (gm2 != null) {
                return gm1.getProjectType() - gm2.getProjectType();
            }
            return -1;
        }
        return 1;
    }
}

