/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.AndroidAutoDetector;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.ArrayList;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintInvalidUsesTagAttributeInspection
extends AndroidLintInspectionBase {
    public AndroidLintInvalidUsesTagAttributeInspection() {
        super(AndroidBundle.message("android.lint.inspections.invalid.uses.tag.attribute", new Object[0]), AndroidAutoDetector.INVALID_USES_TAG_ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        XmlAttributeValue attributeValue;
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintInvalidUsesTagAttributeInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintInvalidUsesTagAttributeInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintInvalidUsesTagAttributeInspection", "getQuickFixes"));
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class);
        XmlAttributeValue xmlAttributeValue = attributeValue = attribute == null ? null : attribute.getValueElement();
        if (attributeValue != null && attributeValue.getTextLength() != 0) {
            String value = StringUtil.unquoteString((String)attributeValue.getText());
            String regexp = "(" + value + ")";
            String[] suggestions = AndroidAutoDetector.getAllowedAutomotiveAppTypes();
            ArrayList fixes = Lists.newArrayListWithExpectedSize((int)suggestions.length);
            for (String suggestion : suggestions) {
                fixes.add(new ReplaceStringQuickFix("Replace with \"" + suggestion + "\"", regexp, suggestion));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = fixes.toArray(new AndroidLintQuickFix[fixes.size()]);
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintInvalidUsesTagAttributeInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintInvalidUsesTagAttributeInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

