/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.lint.AddTargetApiQuickFix;
import com.android.tools.idea.lint.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintNewApiInspection
extends AndroidLintInspectionBase {
    public AndroidLintNewApiInspection() {
        super(AndroidBundle.message("android.lint.inspections.new.api", new Object[0]), ApiDetector.UNSUPPORTED);
    }

    public static AndroidLintQuickFix[] getApiDetectorFixes(@NotNull Issue issue, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issue", "com/android/tools/idea/lint/AndroidLintNewApiInspection", "getApiDetectorFixes"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintNewApiInspection", "getApiDetectorFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintNewApiInspection", "getApiDetectorFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintNewApiInspection", "getApiDetectorFixes"));
        }
        int api = ApiDetector.getRequiredVersion((Issue)issue, (String)message, (TextFormat)TextFormat.RAW);
        if (api != -1) {
            ArrayList list = Lists.newArrayList();
            PsiFile file = startElement.getContainingFile();
            boolean isXml = false;
            if (file instanceof XmlFile) {
                FolderConfiguration config;
                isXml = true;
                ResourceFolderType folderType = ResourceHelper.getFolderType(file);
                if (folderType != null && (config = ResourceHelper.getFolderConfiguration(file)) != null) {
                    config.setVersionQualifier(new VersionQualifier(api));
                    String folder = config.getFolderName(folderType);
                    list.add(OverrideResourceAction.createFix(folder));
                }
            }
            list.add(new AddTargetVersionCheckQuickFix(api));
            list.add(new AddTargetApiQuickFix(api, false, startElement));
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Project project = startElement.getProject();
            if (!isXml && JavaPsiFacade.getInstance((Project)project).findClass("android.support.annotation.RequiresApi", GlobalSearchScope.allScope((Project)project)) != null) {
                list.add(new AddTargetApiQuickFix(api, true, startElement));
            }
            return list.toArray(new AndroidLintQuickFix[list.size()]);
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintNewApiInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintNewApiInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintNewApiInspection", "getQuickFixes"));
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = AndroidLintNewApiInspection.getApiDetectorFixes(ApiDetector.UNSUPPORTED, startElement, endElement, message);
        if (androidLintQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintNewApiInspection", "getQuickFixes"));
        }
        return androidLintQuickFixArray;
    }
}

