/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.energy.view;

import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.common.formatter.EnergyAxisFormatter;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseLineChartSegment;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class EnergySegment
extends BaseLineChartSegment {
    private static final String SEGMENT_NAME = "Energy";
    private static final Color ENERGY_TOTAL_COLOR = new JBColor(new Color(200, 200, 200), new Color(200, 200, 200));
    private static final Color ENERGY_SCREEN_COLOR = new JBColor(new Color(200, 200, 100), new Color(200, 200, 100));
    private static final Color ENERGY_CPU_SYSTEM_COLOR = new JBColor(new Color(200, 50, 50), new Color(200, 50, 50));
    private static final Color ENERGY_CPU_USER_COLOR = new JBColor(new Color(250, 50, 50), new Color(250, 50, 50));
    private static final Color ENERGY_SENSORS_COLOR = new JBColor(new Color(200, 100, 0), new Color(200, 100, 0));
    private static final Color ENERGY_CELL_NETWORK_COLOR = new JBColor(new Color(100, 200, 150), new Color(100, 200, 150));
    private static final Color ENERGY_WIFI_NETWORK_COLOR = new JBColor(new Color(100, 150, 200), new Color(100, 150, 200));

    public EnergySegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/energy/view/EnergySegment", "<init>"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/energy/view/EnergySegment", "<init>"));
        }
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "com/android/tools/idea/monitor/ui/energy/view/EnergySegment", "<init>"));
        }
        super(SEGMENT_NAME, timeCurrentRangeUs, dataStore, (BaseAxisFormatter)EnergyAxisFormatter.SIMPLE, (BaseAxisFormatter)EnergyAxisFormatter.DETAILED, null, dispatcher);
    }

    @Override
    public BaseProfilerUiManager.ProfilerType getProfilerType() {
        return BaseProfilerUiManager.ProfilerType.ENERGY;
    }

    @Override
    protected void updateChartLines(boolean isExpanded) {
        if (isExpanded) {
            this.addEnergyLevelLine(SeriesDataType.ENERGY_SCREEN, ENERGY_SCREEN_COLOR);
            this.addEnergyLevelLine(SeriesDataType.ENERGY_CPU_SYSTEM, ENERGY_CPU_SYSTEM_COLOR);
            this.addEnergyLevelLine(SeriesDataType.ENERGY_CPU_USER, ENERGY_CPU_USER_COLOR);
            this.addEnergyLevelLine(SeriesDataType.ENERGY_CELL_NETWORK, ENERGY_CELL_NETWORK_COLOR);
            this.addEnergyLevelLine(SeriesDataType.ENERGY_WIFI_NETWORK, ENERGY_WIFI_NETWORK_COLOR);
            this.addLeftAxisLine(SeriesDataType.ENERGY_TOTAL, SeriesDataType.ENERGY_TOTAL.toString(), new LineConfig(ENERGY_TOTAL_COLOR));
        } else {
            this.addEnergyLevelLine(SeriesDataType.ENERGY_TOTAL, ENERGY_TOTAL_COLOR);
        }
    }

    private void addEnergyLevelLine(SeriesDataType type, Color color) {
        this.addLeftAxisLine(type, type.toString(), new LineConfig(color).setFilled(true).setStacked(true));
    }
}

