/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.events.view;

import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.events.view.EventSegment;
import com.google.common.collect.Sets;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class EventProfilerUiManager
extends BaseProfilerUiManager {
    private static final int EVENT_MONITOR_MIN_HEIGHT = JBUI.scale((int)55);
    private static final Icon[] ICONS = new Icon[]{AndroidIcons.Profiler.Touch, AndroidIcons.Profiler.TouchHold, AndroidIcons.Profiler.DoubleTap, AndroidIcons.Profiler.Rotation};

    public EventProfilerUiManager(@NotNull Range timeCurrentRangeUs, @NotNull Choreographer choreographer, @NotNull SeriesDataStore datastore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/events/view/EventProfilerUiManager", "<init>"));
        }
        if (choreographer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choreographer", "com/android/tools/idea/monitor/ui/events/view/EventProfilerUiManager", "<init>"));
        }
        if (datastore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "datastore", "com/android/tools/idea/monitor/ui/events/view/EventProfilerUiManager", "<init>"));
        }
        if (eventDispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventDispatcher", "com/android/tools/idea/monitor/ui/events/view/EventProfilerUiManager", "<init>"));
        }
        super(timeCurrentRangeUs, choreographer, datastore, eventDispatcher);
    }

    @Override
    public Set<Poller> createPollers(int pid) {
        return Sets.newHashSet();
    }

    @Override
    public void setupOverviewUi(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/android/tools/idea/monitor/ui/events/view/EventProfilerUiManager", "setupOverviewUi"));
        }
        if (overviewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overviewPanel", "com/android/tools/idea/monitor/ui/events/view/EventProfilerUiManager", "setupOverviewUi"));
        }
        this.myOverviewSegment = this.createOverviewSegment(this.myTimeCurrentRangeUs, this.myDataStore, (EventDispatcher<ProfilerEventListener>)this.myEventDispatcher);
        this.setupAndRegisterSegment(this.myOverviewSegment, EVENT_MONITOR_MIN_HEIGHT, EVENT_MONITOR_MIN_HEIGHT, EVENT_MONITOR_MIN_HEIGHT);
        overviewPanel.add(this.myOverviewSegment);
    }

    @Override
    @NotNull
    protected BaseSegment createOverviewSegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/events/view/EventProfilerUiManager", "createOverviewSegment"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/events/view/EventProfilerUiManager", "createOverviewSegment"));
        }
        if (eventDispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventDispatcher", "com/android/tools/idea/monitor/ui/events/view/EventProfilerUiManager", "createOverviewSegment"));
        }
        EventSegment eventSegment = new EventSegment(timeCurrentRangeUs, dataStore, ICONS, eventDispatcher);
        if (eventSegment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/events/view/EventProfilerUiManager", "createOverviewSegment"));
        }
        return eventSegment;
    }
}

