/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class VectorAssetBrowser
extends TextFieldWithBrowseButton
implements AssetComponent<VectorAsset>,
Disposable {
    private final VectorAsset myAsset = new VectorAsset(VectorAsset.FileType.SVG);
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myAssetListeners = Lists.newArrayListWithExpectedSize((int)1);

    public VectorAssetBrowser() {
        this.addBrowseFolderListener(null, null, null, VectorAssetBrowser.createMultiFileDescriptor("svg", "psd"));
        TextProperty absolutePath = new TextProperty(this.getTextField());
        this.myBindings.bind(absolutePath, this.myAsset.path().transform(File::getAbsolutePath));
        this.myBindings.bind(this.myAsset.path(), absolutePath.transform(File::new));
        this.myBindings.bind(this.myAsset.type(), absolutePath.transform(VectorAsset::typeFromExtension));
        this.myAsset.path().addListener(sender -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener : this.myAssetListeners) {
                listener.actionPerformed(e);
            }
        });
    }

    @Override
    @NotNull
    public VectorAsset getAsset() {
        VectorAsset vectorAsset = this.myAsset;
        if (vectorAsset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/VectorAssetBrowser", "getAsset"));
        }
        return vectorAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/android/tools/idea/npw/assetstudio/ui/VectorAssetBrowser", "addAssetListener"));
        }
        this.myAssetListeners.add(l);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myAssetListeners.clear();
    }

    private static FileChooserDescriptor createMultiFileDescriptor(String ... extensions) {
        return new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(file -> Arrays.stream(extensions).anyMatch(e -> Comparing.equal((String)file.getExtension(), (String)e, (boolean)SystemInfo.isFileSystemCaseSensitive)));
    }
}

