/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.errors.ui;

import com.android.tools.idea.rendering.HtmlBuilderHelper;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.utils.HtmlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.AlarmFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderErrorPanel
extends JPanel
implements ListDataListener,
Disposable {
    private static final String TITLE = "Render errors";
    private static final String PROPERTY_MINIMIZED = RenderErrorPanel.class.getCanonicalName() + ".minimized";
    private static final String EMPTY_HTML_BODY = "<html><body></body></html>";
    private static final NotificationGroup NOTIFICATIONS_GROUP = new NotificationGroup("Render error panel notifications", NotificationDisplayType.BALLOON, false);
    @NotNull
    private final JBList myList;
    @NotNull
    private final JEditorPane myHtmlDetailPane;
    @NotNull
    private final JScrollPane myListScrollPane;
    @NotNull
    private final JBLabel myTitleLabel;
    @NotNull
    private final JScrollPane myHtmlScrollPane;
    @NotNull
    private RenderErrorModel myModel = new RenderErrorModel(Collections.emptyList());
    private boolean isMinimized;
    @Nullable
    private MinimizeListener myMinimizeListener;
    private boolean hasUserSeenNewErrors;

    public RenderErrorPanel() {
        super(new BorderLayout());
        this.myHtmlDetailPane = new JEditorPane("text/html", EMPTY_HTML_BODY);
        this.myHtmlDetailPane.setEditable(false);
        this.myHtmlDetailPane.addHyperlinkListener(e -> {
            HyperlinkListener listener = this.myModel.getElementAt(0).getHyperlinkListener();
            if (listener != null) {
                listener.hyperlinkUpdate(e);
            }
        });
        this.myHtmlDetailPane.setContentType("text/html");
        this.myHtmlDetailPane.setMargin((Insets)JBUI.insets((int)10));
        this.myList = new JBList();
        this.myList.setPrototypeCellValue((Object)RenderErrorModel.Issue.builder().setSummary("Prototype").build());
        this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<RenderErrorModel.Issue>(){

            protected void customizeCellRenderer(JList list, @NotNull RenderErrorModel.Issue value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/rendering/errors/ui/RenderErrorPanel$1", "customizeCellRenderer"));
                }
                Icon icon = RenderErrorPanel.getSeverityIcon(value.getSeverity());
                if (icon != null) {
                    this.setIcon(icon);
                }
                this.append(value.getSummary());
            }
        });
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(e -> {
            int selectedIndex = this.myList.getSelectedIndex();
            if (selectedIndex != -1) {
                HtmlBuilder htmlBuilder = new HtmlBuilder();
                RenderErrorModel.Issue selectedIssue = (RenderErrorModel.Issue)this.myList.getModel().getElementAt(selectedIndex);
                htmlBuilder.addHtml(selectedIssue.getHtmlContent()).newline();
                try {
                    this.myHtmlDetailPane.read(new StringReader(htmlBuilder.getHtml()), null);
                    HtmlBuilderHelper.fixFontStyles(this.myHtmlDetailPane);
                    this.myHtmlDetailPane.setCaretPosition(0);
                }
                catch (IOException e1) {
                    this.setEmptyHtmlDetail();
                }
            } else {
                this.setEmptyHtmlDetail();
            }
            this.revalidate();
            this.repaint();
        });
        ActionToolbarImpl toolbar = new ActionToolbarImpl("unknown", this.getActionGroup(), true, false, DataManager.getInstance(), ActionManagerEx.getInstanceEx(), KeymapManagerEx.getInstanceEx());
        toolbar.setLayoutPolicy(0);
        toolbar.setBorder((Border)JBUI.Borders.empty());
        Box titlePanel = Box.createHorizontalBox();
        this.myTitleLabel = new JBLabel(TITLE, 2);
        this.myTitleLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)20));
        this.myTitleLabel.setPreferredSize(new Dimension(Short.MAX_VALUE, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height));
        this.myTitleLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MinimizeAction minimizeAction = new MinimizeAction();
                    AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)minimizeAction, (InputEvent)e, (String)"unknown", (DataContext)DataManager.getInstance().getDataContext((Component)RenderErrorPanel.this.myTitleLabel));
                    ActionUtil.performActionDumbAware((AnAction)minimizeAction, (AnActionEvent)event);
                }
            }
        });
        titlePanel.add((Component)this.myTitleLabel);
        titlePanel.add(toolbar.getComponent());
        titlePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height));
        this.myListScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myList);
        this.myListScrollPane.setMinimumSize((Dimension)JBUI.size((int)0, (int)(this.myList.getFixedCellHeight() * 3)));
        this.myListScrollPane.setPreferredSize((Dimension)JBUI.size((int)Short.MAX_VALUE, (int)(this.myList.getFixedCellHeight() * 3)));
        this.myListScrollPane.setMaximumSize((Dimension)JBUI.size((int)Short.MAX_VALUE, (int)(this.myList.getFixedCellHeight() * 5)));
        this.myListScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myHtmlScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myHtmlDetailPane);
        this.myHtmlScrollPane.setBorder(JBUI.Borders.customLine((Color)UIUtil.getPanelBackground(), (int)5, (int)0, (int)0, (int)0));
        Box rootPanel = Box.createVerticalBox();
        titlePanel.setAlignmentX(0.5f);
        this.myListScrollPane.setAlignmentX(0.5f);
        this.myHtmlScrollPane.setAlignmentX(0.5f);
        rootPanel.add(titlePanel);
        rootPanel.add(this.myListScrollPane);
        rootPanel.add(this.myHtmlScrollPane);
        this.add(rootPanel);
        this.isMinimized = PropertiesComponent.getInstance().getBoolean(PROPERTY_MINIMIZED, false);
        this.myListScrollPane.setVisible(!this.isMinimized);
        this.myHtmlScrollPane.setVisible(!this.isMinimized);
        this.updateTitlebarStyle();
    }

    @Nullable
    private static Icon getSeverityIcon(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/android/tools/idea/rendering/errors/ui/RenderErrorPanel", "getSeverityIcon"));
        }
        if (severity.equals((Object)HighlightSeverity.ERROR)) {
            return AllIcons.General.Error;
        }
        if (severity.equals((Object)HighlightSeverity.WARNING)) {
            return AllIcons.General.Warning;
        }
        return AllIcons.General.Information;
    }

    public static void showNotification(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/android/tools/idea/rendering/errors/ui/RenderErrorPanel", "showNotification"));
        }
        Notification notification = NOTIFICATIONS_GROUP.createNotification(content, NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)notification);
        AlarmFactory.getInstance().create().addRequest(() -> ((Notification)notification).expire(), TimeUnit.SECONDS.toMillis(2L));
    }

    public void dispose() {
        this.myModel.removeListDataListener(this);
        this.myMinimizeListener = null;
    }

    @NotNull
    public RenderErrorModel getModel() {
        RenderErrorModel renderErrorModel = this.myModel;
        if (renderErrorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorPanel", "getModel"));
        }
        return renderErrorModel;
    }

    public void setModel(@NotNull RenderErrorModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/rendering/errors/ui/RenderErrorPanel", "setModel"));
        }
        if (model.equals(this.myModel)) {
            return;
        }
        this.myModel.removeListDataListener(this);
        this.hasUserSeenNewErrors = !this.isMinimized();
        this.myModel = model;
        this.myModel.addListDataListener(this);
        this.contentsChanged(new ListDataEvent(this.myModel, 0, 0, this.myModel.getSize()));
    }

    @NotNull
    private ActionGroup getActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new MinimizeAction());
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorPanel", "getActionGroup"));
        }
        return defaultActionGroup;
    }

    private void setEmptyHtmlDetail() {
        UIUtil.invokeLaterIfNeeded(() -> {
            try {
                this.myHtmlDetailPane.read(new StringReader(EMPTY_HTML_BODY), null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        List orderedIssues = this.myModel.getIssues().stream().sorted().collect(Collectors.toList());
        UIUtil.invokeLaterIfNeeded(() -> {
            int currentSelectedIndex = this.myList.getItemsCount() == 0 ? 0 : this.myList.getSelectedIndex();
            this.myList.setModel((ListModel)new CollectionListModel(orderedIssues));
            this.myList.setSelectedIndex(this.myModel.getSize() > 0 ? currentSelectedIndex : -1);
            this.myList.setSelectedIndex(currentSelectedIndex);
            this.setVisible(this.myModel.getSize() > 0);
            this.updateTitlebarStyle();
            this.revalidate();
            this.repaint();
        });
    }

    public boolean isMinimized() {
        return this.isMinimized;
    }

    public void setMinimized(boolean minimized) {
        if (minimized == this.isMinimized) {
            return;
        }
        if (!minimized) {
            this.hasUserSeenNewErrors = true;
        }
        this.isMinimized = minimized;
        this.myListScrollPane.setVisible(!this.isMinimized);
        this.myHtmlScrollPane.setVisible(!this.isMinimized);
        this.updateTitlebarStyle();
        this.revalidate();
        this.repaint();
        if (this.myMinimizeListener != null) {
            UIUtil.invokeLaterIfNeeded(() -> this.myMinimizeListener.onMinimizeChanged(this.isMinimized));
        }
    }

    private void updateTitlebarStyle() {
        this.myTitleLabel.setFont(this.myTitleLabel.getFont().deriveFont(!this.isMinimized() || this.hasUserSeenNewErrors ? 0 : 1));
        if (this.isMinimized) {
            this.myTitleLabel.setText(String.format("%1$s (%2$d issues)", TITLE, this.getModel().getSize()));
            this.myTitleLabel.setIcon(RenderErrorPanel.getSeverityIcon(this.getModel().getHighestSeverity()));
        } else {
            this.myTitleLabel.setText(TITLE);
            this.myTitleLabel.setIcon(null);
        }
    }

    public void setMinimizeListener(@Nullable MinimizeListener listener) {
        this.myMinimizeListener = listener;
    }

    @VisibleForTesting
    @NotNull
    public JEditorPane getHtmlDetailPane() {
        JEditorPane jEditorPane = this.myHtmlDetailPane;
        if (jEditorPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorPanel", "getHtmlDetailPane"));
        }
        return jEditorPane;
    }

    private class MinimizeAction
    extends AnAction
    implements RightAlignedToolbarAction {
        private static final String DESCRIPTION = "Minimize/Restore the render errors panel";

        private MinimizeAction() {
            super(DESCRIPTION, DESCRIPTION, AllIcons.General.HideDown);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/rendering/errors/ui/RenderErrorPanel$MinimizeAction", "actionPerformed"));
            }
            boolean newMinimizedState = !RenderErrorPanel.this.isMinimized();
            RenderErrorPanel.this.setMinimized(newMinimizedState);
            PropertiesComponent.getInstance().setValue(PROPERTY_MINIMIZED, newMinimizedState, false);
            this.update(e);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/rendering/errors/ui/RenderErrorPanel$MinimizeAction", "update"));
            }
            e.getPresentation().setIcon(RenderErrorPanel.this.isMinimized() ? AllIcons.Debugger.RestoreLayout : AllIcons.General.HideDown);
        }
    }

    public static interface MinimizeListener {
        public void onMinimizeChanged(boolean var1);
    }
}

