/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class GradleApplicationIdProvider
implements ApplicationIdProvider {
    private static final String DEFAULT_TEST_PACKAGE_SUFFIX = ".test";
    @NotNull
    private final AndroidFacet myFacet;

    public GradleApplicationIdProvider(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/GradleApplicationIdProvider", "<init>"));
        }
        this.myFacet = facet;
    }

    @Override
    @NotNull
    public String getPackageName() throws ApkProvisionException {
        String string = ApkProviderUtil.computePackageName(this.myFacet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/GradleApplicationIdProvider", "getPackageName"));
        }
        return string;
    }

    @Override
    public String getTestPackageName() throws ApkProvisionException {
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        assert (androidModel != null);
        Variant selectedVariant = androidModel.getSelectedVariant();
        String testPackageName = selectedVariant.getMergedFlavor().getTestApplicationId();
        return testPackageName != null ? testPackageName : this.getPackageName() + DEFAULT_TEST_PACKAGE_SUFFIX;
    }
}

