/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultStartActivityFlagsProvider
implements StartActivityFlagsProvider {
    @Nullable
    private final AndroidDebugger myAndroidDebugger;
    @Nullable
    private final AndroidDebuggerState myAndroidDebuggerState;
    @NotNull
    private final ProfilerState myProfilerState;
    private final boolean myWaitForDebugger;
    @NotNull
    private final String myExtraFlags;
    private final Project myProject;

    public DefaultStartActivityFlagsProvider(@Nullable AndroidDebugger androidDebugger, @Nullable AndroidDebuggerState androidDebuggerState, @NotNull Project project, boolean waitForDebugger, @NotNull String extraFlags) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/activity/DefaultStartActivityFlagsProvider", "<init>"));
        }
        if (extraFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraFlags", "com/android/tools/idea/run/activity/DefaultStartActivityFlagsProvider", "<init>"));
        }
        this(androidDebugger, androidDebuggerState, new ProfilerState(), project, waitForDebugger, extraFlags);
    }

    public DefaultStartActivityFlagsProvider(@Nullable AndroidDebugger androidDebugger, @Nullable AndroidDebuggerState androidDebuggerState, @NotNull ProfilerState profilerState, @NotNull Project project, boolean waitForDebugger, @NotNull String extraFlags) {
        if (profilerState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilerState", "com/android/tools/idea/run/activity/DefaultStartActivityFlagsProvider", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/activity/DefaultStartActivityFlagsProvider", "<init>"));
        }
        if (extraFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraFlags", "com/android/tools/idea/run/activity/DefaultStartActivityFlagsProvider", "<init>"));
        }
        this.myAndroidDebugger = androidDebugger;
        this.myAndroidDebuggerState = androidDebuggerState;
        this.myProfilerState = profilerState;
        this.myWaitForDebugger = waitForDebugger;
        this.myExtraFlags = extraFlags;
        this.myProject = project;
    }

    @Override
    @NotNull
    public String getFlags(@NotNull IDevice device) {
        String extraOptions;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/activity/DefaultStartActivityFlagsProvider", "getFlags"));
        }
        LinkedList flags = Lists.newLinkedList();
        if (this.myWaitForDebugger) {
            flags.add("-D");
        }
        if (!this.myExtraFlags.isEmpty()) {
            flags.add(this.myExtraFlags);
        }
        if (this.myWaitForDebugger && this.myAndroidDebugger != null && !(extraOptions = this.myAndroidDebugger.getAmStartOptions(this.myAndroidDebuggerState, this.myProject, device.getVersion())).isEmpty()) {
            flags.add(extraOptions);
        }
        String string = StringUtil.join((Collection)flags, (String)" ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/DefaultStartActivityFlagsProvider", "getFlags"));
        }
        return string;
    }
}

