/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.google.common.collect.Sets;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidDebuggerImplBase<S extends AndroidDebuggerState>
implements AndroidDebugger<S> {
    private Set<XBreakpointType<?, ?>> mySupportedBreakpointTypes;
    private final Set<Class<? extends XBreakpointType<?, ?>>> breakpointTypeClasses;

    protected AndroidDebuggerImplBase(Set<Class<? extends XBreakpointType<?, ?>>> breakpointTypeClasses) {
        this.breakpointTypeClasses = breakpointTypeClasses;
    }

    @NotNull
    protected static String getClientDebugPort(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "getClientDebugPort"));
        }
        String string = Integer.toString(client.getDebuggerListenPort()).trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "getClientDebugPort"));
        }
        return string;
    }

    @Nullable
    protected static DebuggerSession findJdwpDebuggerSession(@NotNull Project project, @NotNull String debugPort) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "findJdwpDebuggerSession"));
        }
        if (debugPort == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugPort", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "findJdwpDebuggerSession"));
        }
        for (DebuggerSession session : DebuggerManagerEx.getInstanceEx((Project)project).getSessions()) {
            if (!debugPort.equals(session.getProcess().getConnection().getAddress().trim())) continue;
            return session;
        }
        return null;
    }

    protected static boolean activateDebugSessionWindow(@NotNull Project project, @NotNull RunContentDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "activateDebugSessionWindow"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "activateDebugSessionWindow"));
        }
        ProcessHandler processHandler = descriptor.getProcessHandler();
        Content content = descriptor.getAttachedContent();
        if (processHandler == null || content == null) {
            return false;
        }
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        if (processHandler.isProcessTerminated()) {
            ExecutionManager.getInstance((Project)project).getContentManager().removeRunContent(executor, descriptor);
            return false;
        }
        content.getManager().setSelectedContent(content);
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(executor.getToolWindowId());
        window.activate(null, false, true);
        return true;
    }

    @Override
    @NotNull
    public synchronized Set<XBreakpointType<?, ?>> getSupportedBreakpointTypes(@NotNull Project project, @NotNull AndroidVersion version) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "getSupportedBreakpointTypes"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "getSupportedBreakpointTypes"));
        }
        if (this.mySupportedBreakpointTypes == null) {
            XDebuggerUtil debuggerUtil = XDebuggerUtil.getInstance();
            this.mySupportedBreakpointTypes = Sets.newHashSet();
            for (Class<? extends XBreakpointType<?, ?>> clazz : this.breakpointTypeClasses) {
                this.mySupportedBreakpointTypes.add(debuggerUtil.findBreakpointType(clazz));
            }
        }
        Set<XBreakpointType<?, ?>> set = this.mySupportedBreakpointTypes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "getSupportedBreakpointTypes"));
        }
        return set;
    }

    @Override
    public boolean shouldBeDefault() {
        return false;
    }

    @Override
    @NotNull
    public String getAmStartOptions(@NotNull S state, @NotNull Project project, @NotNull AndroidVersion version) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "getAmStartOptions"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "getAmStartOptions"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "getAmStartOptions"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidDebuggerImplBase", "getAmStartOptions"));
        }
        return "";
    }
}

