/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Repository;
import com.android.repository.api.Uninstaller;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.installer.AbstractInstallerFactory;
import com.android.repository.impl.installer.AbstractUninstaller;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.install.StudioSdkInstallListenerFactory;
import com.android.tools.idea.sdk.install.patch.PatchInstallerFactory;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchInstallingRestarter {
    private static final String OLD_PACKAGE_XML_FN = "package.xml.old";
    private final AndroidSdkHandler mySdkHandler;
    private final FileOp myFileOp;

    public PatchInstallingRestarter(@NotNull AndroidSdkHandler sdkHandler, @NotNull FileOp fileOp) {
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter", "<init>"));
        }
        if (fileOp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter", "<init>"));
        }
        this.mySdkHandler = sdkHandler;
        this.myFileOp = fileOp;
    }

    public void restartAndInstallIfNecessary() {
        File patchesDir = new File(this.mySdkHandler.getLocation(), ".patches");
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(PatchInstallerFactory.class);
        if (patchesDir.exists()) {
            File[] subDirs;
            for (File patchDir : subDirs = patchesDir.listFiles(file -> file.isDirectory() && file.getName().startsWith(PatchInstallerUtil.PATCH_DIR_PREFIX))) {
                this.processPatch(this.mySdkHandler.getLocation(), progress, patchDir);
            }
        }
    }

    private void processPatch(File androidSdkPath, StudioLoggerProgressIndicator progress, File patchDir) {
        LocalPackage pendingPackage = null;
        File installDir = null;
        try {
            RepoManager mgr = this.mySdkHandler.getSdkManager((ProgressIndicator)progress);
            Repository repo = InstallerUtil.readPendingPackageXml((File)patchDir, (RepoManager)mgr, (FileOp)this.myFileOp, (ProgressIndicator)progress);
            if (repo != null) {
                File patch = new File(patchDir, "patch.jar");
                pendingPackage = repo.getLocalPackage();
                boolean remote = false;
                if (pendingPackage != null) {
                    installDir = ((LocalPackage)mgr.getPackages().getLocalPackages().get(pendingPackage.getPath())).getLocation();
                } else {
                    pendingPackage = (RepoPackage)repo.getRemotePackage().get(0);
                    installDir = ((RemotePackage)pendingPackage).getInstallDir(mgr, (ProgressIndicator)progress);
                    remote = true;
                }
                File existingPackageXml = new File(installDir, "package.xml");
                File oldPackageXml = new File(patchDir, OLD_PACKAGE_XML_FN);
                if (!patch.exists() || !existingPackageXml.renameTo(oldPackageXml)) {
                    String relativePath = FileOpUtils.makeRelative((File)androidSdkPath, (File)installDir, (FileOp)this.myFileOp);
                    Revision rev = AndroidCommonUtils.parsePackageRevision((String)androidSdkPath.getPath(), (String)relativePath);
                    if (rev != null && rev.equals((Object)pendingPackage.getVersion())) {
                        DummyInstallerFactory dummyFactory = new DummyInstallerFactory();
                        dummyFactory.setListenerFactory((InstallerFactory.StatusChangeListenerFactory)new StudioSdkInstallListenerFactory(this.mySdkHandler));
                        if (remote) {
                            Installer installer = dummyFactory.createInstaller((RemotePackage)pendingPackage, mgr, new StudioDownloader(), this.myFileOp);
                            installer.complete((ProgressIndicator)progress);
                        } else {
                            Uninstaller uninstaller = dummyFactory.createUninstaller(pendingPackage, mgr, this.myFileOp);
                            uninstaller.complete((ProgressIndicator)progress);
                        }
                    } else {
                        progress.logWarning("Failed to find version information in " + new File(androidSdkPath, "source.properties"));
                        oldPackageXml.renameTo(existingPackageXml);
                    }
                }
            }
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder("A problem occurred while installing ");
            message.append(pendingPackage != null ? pendingPackage.getDisplayName() : "an SDK package");
            if (installDir != null) {
                message.append(" in ").append(installDir);
            }
            message.append(". Please try again.");
            Messages.showErrorDialog((String)message.toString(), (String)"Error Launching SDK Component Installer");
            progress.logWarning("Failed to install SDK package", e);
        }
        try {
            this.myFileOp.deleteFileOrFolder(patchDir);
        }
        catch (Exception e) {
            progress.logWarning("Problem during patch cleanup", e);
        }
    }

    private static class DummyInstallerFactory
    extends AbstractInstallerFactory {
        private DummyInstallerFactory() {
        }

        @NotNull
        protected Installer doCreateInstaller(@NotNull RemotePackage p, @NotNull RepoManager mgr, @NotNull Downloader downloader, @NotNull FileOp fop) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory", "doCreateInstaller"));
            }
            if (mgr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory", "doCreateInstaller"));
            }
            if (downloader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloader", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory", "doCreateInstaller"));
            }
            if (fop == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory", "doCreateInstaller"));
            }
            AbstractInstaller abstractInstaller = new AbstractInstaller(p, mgr, downloader, fop){

                protected boolean doComplete(@Nullable File installTemp, @NotNull ProgressIndicator progress) {
                    if (progress == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory$1", "doComplete"));
                    }
                    return true;
                }

                protected boolean doPrepare(@NotNull File installTempPath, @NotNull ProgressIndicator progress) {
                    if (installTempPath == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installTempPath", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory$1", "doPrepare"));
                    }
                    if (progress == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory$1", "doPrepare"));
                    }
                    return false;
                }
            };
            if (abstractInstaller == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory", "doCreateInstaller"));
            }
            return abstractInstaller;
        }

        @NotNull
        protected Uninstaller doCreateUninstaller(@NotNull LocalPackage p, @NotNull RepoManager mgr, @NotNull FileOp fop) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory", "doCreateUninstaller"));
            }
            if (mgr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory", "doCreateUninstaller"));
            }
            if (fop == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory", "doCreateUninstaller"));
            }
            AbstractUninstaller abstractUninstaller = new AbstractUninstaller(p, mgr, fop){

                protected boolean doPrepare(@Nullable File installTemp, ProgressIndicator progress) {
                    return false;
                }

                protected boolean doComplete(@Nullable File installTemp, ProgressIndicator progress) {
                    return true;
                }
            };
            if (abstractUninstaller == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchInstallingRestarter$DummyInstallerFactory", "doCreateUninstaller"));
            }
            return abstractUninstaller;
        }
    }
}

