/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.GradleFilePsiMerger;
import com.android.tools.idea.templates.GradleFileSimpleMerger;
import com.android.tools.idea.templates.RecipeMergeUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.FindReferencesRecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.google.common.base.Strings;
import com.google.common.collect.SetMultimap;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.LineSeparator;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultRecipeExecutor
implements RecipeExecutor {
    private static final String GRADLE_PROJECT_SETTINGS_FILE = "settings.gradle";
    private static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private static final String LINE_SEPARATOR = LineSeparator.getSystemLineSeparator().getSeparatorString();
    private final FindReferencesRecipeExecutor myReferences;
    private final RenderingContext myContext;
    private final RecipeIO myIO;
    private final ReadonlyStatusHandler myReadonlyStatusHandler;
    private boolean myNeedsGradleSync;

    public DefaultRecipeExecutor(@NotNull RenderingContext context, boolean dryRun) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "<init>"));
        }
        this.myReferences = new FindReferencesRecipeExecutor(context);
        this.myContext = context;
        this.myIO = dryRun ? new DryRunRecipeIO() : new RecipeIO();
        this.myReadonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)context.getProject());
    }

    @NotNull
    private static GradleBuildModel getBuildModel(@NotNull File buildFile, @NotNull Project project) {
        if (buildFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getBuildModel"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getBuildModel"));
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)buildFile, (boolean)true);
        if (virtualFile == null) {
            throw new RuntimeException("Failed to find " + buildFile.getPath());
        }
        GradleBuildModel gradleBuildModel = GradleBuildModel.parseBuildFile(virtualFile, project, project.getName());
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getBuildModel"));
        }
        return gradleBuildModel;
    }

    @Override
    public void applyPlugin(@NotNull String plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "applyPlugin"));
        }
        plugin = plugin.trim();
        this.myReferences.applyPlugin(plugin);
        Project project = this.myContext.getProject();
        File buildFile = GradleUtil.getGradleBuildFilePath(this.myContext.getModuleRoot());
        if (project.isInitialized()) {
            GradleBuildModel buildModel = DefaultRecipeExecutor.getBuildModel(buildFile, project);
            if (!buildModel.appliedPlugins().contains(plugin)) {
                buildModel.applyPlugin(plugin);
                this.myIO.applyChanges(buildModel);
            }
        } else {
            String destinationContents = buildFile.exists() ? Strings.nullToEmpty((String)this.readTextFile(buildFile)) : "";
            String applyPluginStatement = "apply plugin: '" + plugin + "'";
            String result = destinationContents.isEmpty() ? applyPluginStatement : destinationContents + LINE_SEPARATOR + applyPluginStatement;
            try {
                this.myIO.writeFile(this, result, buildFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.myNeedsGradleSync = true;
    }

    @Override
    public void addClasspath(@NotNull String mavenUrl) {
        if (mavenUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenUrl", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "addClasspath"));
        }
        mavenUrl = mavenUrl.trim();
        this.myReferences.addClasspath(mavenUrl);
        ArtifactDependencySpec toBeAddedDependency = ArtifactDependencySpec.create(mavenUrl);
        if (toBeAddedDependency == null) {
            throw new RuntimeException(mavenUrl + " is not a valid classpath dependency");
        }
        Project project = this.myContext.getProject();
        File rootBuildFile = GradleUtil.getGradleBuildFilePath(Projects.getBaseDirPath(project));
        if (project.isInitialized()) {
            GradleBuildModel buildModel = DefaultRecipeExecutor.getBuildModel(rootBuildFile, project);
            DependenciesModel buildscriptDependencies = buildModel.buildscript().dependencies();
            ArtifactDependencyModel targetDependencyModel = null;
            for (ArtifactDependencyModel dependencyModel : buildscriptDependencies.artifacts(CLASSPATH_CONFIGURATION_NAME)) {
                if (!toBeAddedDependency.equalsIgnoreVersion(ArtifactDependencySpec.create(dependencyModel))) continue;
                targetDependencyModel = dependencyModel;
            }
            if (targetDependencyModel == null) {
                buildscriptDependencies.addArtifact(CLASSPATH_CONFIGURATION_NAME, toBeAddedDependency);
            } else {
                GradleVersion existingDependencyVersion;
                GradleVersion toBeAddedDependencyVersion = GradleVersion.parse((String)Strings.nullToEmpty((String)toBeAddedDependency.version));
                if (toBeAddedDependencyVersion.compareTo(existingDependencyVersion = GradleVersion.parse((String)Strings.nullToEmpty((String)((String)targetDependencyModel.version().value())))) > 0) {
                    targetDependencyModel.setVersion(Strings.nullToEmpty((String)toBeAddedDependency.version));
                }
            }
            this.myIO.applyChanges(buildModel);
        } else {
            String destinationContents = rootBuildFile.exists() ? Strings.nullToEmpty((String)this.readTextFile(rootBuildFile)) : "";
            String result = this.myIO.mergeGradleFiles(DefaultRecipeExecutor.formatClasspath(mavenUrl), destinationContents, project, "");
            try {
                this.myIO.writeFile(this, result, rootBuildFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.myNeedsGradleSync = true;
    }

    @NotNull
    private static String formatClasspath(@NotNull String dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "formatClasspath"));
        }
        String string = "buildscript {" + LINE_SEPARATOR + "  dependencies {" + LINE_SEPARATOR + "    classpath '" + dependency + "'" + LINE_SEPARATOR + "  }" + LINE_SEPARATOR + "}" + LINE_SEPARATOR;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "formatClasspath"));
        }
        return string;
    }

    @Override
    public void addDependency(@NotNull String configuration, @NotNull String mavenUrl) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "addDependency"));
        }
        if (mavenUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenUrl", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "addDependency"));
        }
        this.myReferences.addDependency(configuration, mavenUrl);
        SetMultimap dependencyList = (SetMultimap)this.getParamMap().get("dependenciesMultimap");
        dependencyList.put((Object)configuration, (Object)mavenUrl);
    }

    @Override
    public void addFilesToOpen(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "addFilesToOpen"));
        }
        this.myReferences.addFilesToOpen(file);
    }

    private void addWarning(@NotNull String warning) {
        if (warning == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warning", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "addWarning"));
        }
        this.myContext.getWarnings().add(warning);
    }

    @NotNull
    private Map<String, Object> getParamMap() {
        Map<String, Object> map = this.myContext.getParamMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getParamMap"));
        }
        return map;
    }

    @NotNull
    Configuration getFreemarker() {
        Configuration configuration = this.myContext.getFreemarkerConfiguration();
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getFreemarker"));
        }
        return configuration;
    }

    @Override
    public void copy(@NotNull File from, @NotNull File to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copy"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copy"));
        }
        try {
            this.copyTemplateResource(from, to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void instantiate(@NotNull File from, @NotNull File to) throws FreemarkerUtils.TemplateProcessingException {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "instantiate"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "instantiate"));
        }
        try {
            boolean isDirectory;
            boolean bl = isDirectory = from.getName().indexOf(46) == -1;
            if (isDirectory) {
                this.copyTemplateResource(from, to);
            } else {
                File sourceFile = this.myContext.getLoader().getSourceFile(from);
                File targetFile = this.getTargetFile(to);
                String content = FreemarkerUtils.processFreemarkerTemplate(this.myContext, sourceFile, null);
                if (targetFile.exists()) {
                    if (!this.compareTextFile(targetFile, content)) {
                        this.addFileAlreadyExistWarning(targetFile);
                    }
                } else {
                    this.myIO.writeFile(this, content, targetFile);
                    this.myReferences.addSourceFile(sourceFile);
                    this.myReferences.addTargetFile(targetFile);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void merge(@NotNull File from, @NotNull File to) throws FreemarkerUtils.TemplateProcessingException {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "merge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "merge"));
        }
        try {
            String contents;
            String sourceText;
            String targetText = null;
            File sourceFile = this.myContext.getLoader().getSourceFile(from);
            File targetFile = this.getTargetFile(to);
            if (!TemplateUtils.hasExtension(targetFile, ".xml") && !TemplateUtils.hasExtension(targetFile, ".gradle")) {
                throw new RuntimeException("Only XML or Gradle files can be merged at this point: " + targetFile);
            }
            if (targetFile.exists()) {
                VirtualFile toFile;
                ReadonlyStatusHandler.OperationStatus status;
                if (this.myContext.getProject().isInitialized() && (status = this.myReadonlyStatusHandler.ensureFilesWritable(new VirtualFile[]{toFile = VfsUtil.findFileByIoFile((File)targetFile, (boolean)true)})).hasReadonlyFiles()) {
                    throw new FreemarkerUtils.TemplateUserVisibleException(String.format("Attempt to update file that is readonly: %1$s", targetFile.getAbsolutePath()));
                }
                targetText = this.readTextFile(targetFile);
            }
            if (targetText == null) {
                boolean instantiate = TemplateUtils.hasExtension(from, ".ftl");
                if (instantiate) {
                    this.instantiate(from, targetFile);
                } else {
                    this.copyTemplateResource(from, targetFile);
                }
                return;
            }
            if (TemplateUtils.hasExtension(from, ".ftl")) {
                sourceText = FreemarkerUtils.processFreemarkerTemplate(this.myContext, from, null);
            } else {
                sourceText = TemplateUtils.readTextFromDisk(sourceFile);
                if (sourceText == null) {
                    return;
                }
            }
            if (targetFile.getName().equals(GRADLE_PROJECT_SETTINGS_FILE)) {
                contents = RecipeMergeUtils.mergeGradleSettingsFile(sourceText, targetText);
                this.myNeedsGradleSync = true;
            } else if (targetFile.getName().equals("build.gradle")) {
                String compileSdkVersion = (String)this.getParamMap().get("buildApiString");
                contents = this.myIO.mergeGradleFiles(sourceText, targetText, this.myContext.getProject(), compileSdkVersion);
                this.myNeedsGradleSync = true;
            } else if (TemplateUtils.hasExtension(targetFile, ".xml")) {
                contents = RecipeMergeUtils.mergeXml(this.myContext, sourceText, targetText, targetFile);
            } else {
                throw new RuntimeException("Only XML or Gradle settings files can be merged at this point: " + targetFile);
            }
            this.myIO.writeFile(this, contents, targetFile);
            this.myReferences.addSourceFile(sourceFile);
            this.myReferences.addTargetFile(targetFile);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void append(@NotNull File from, @NotNull File to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "append"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "append"));
        }
        try {
            File sourceFile = this.myContext.getLoader().getSourceFile(from);
            File targetFile = this.getTargetFile(to);
            String sourceText = TemplateUtils.readTextFromDisk(sourceFile);
            if (sourceText == null) {
                return;
            }
            if (targetFile.exists()) {
                String targetContents = TemplateUtils.readTextFromDisk(targetFile);
                String resultContents = (targetContents == null ? "" : targetContents + LINE_SEPARATOR) + sourceText;
                this.myIO.writeFile(this, resultContents, targetFile);
            } else {
                this.myIO.writeFile(this, sourceText, targetFile);
            }
            this.myReferences.addSourceFile(sourceFile);
            this.myReferences.addTargetFile(targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void mkDir(@NotNull File at) {
        if (at == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "at", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "mkDir"));
        }
        try {
            this.myIO.mkDir(this.getTargetFile(at));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateAndSyncGradle() {
        if (!this.myContext.getDependencies().isEmpty()) {
            try {
                this.mergeDependenciesIntoGradle();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Project project = this.myContext.getProject();
        if (this.myNeedsGradleSync && this.myContext.performGradleSync() && !project.isDefault() && Projects.isBuildWithGradle(project)) {
            this.myIO.requestGradleSync(project);
        }
    }

    @Override
    public void pushFolder(@NotNull String folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "pushFolder"));
        }
        try {
            this.myContext.getLoader().pushTemplateFolder(folder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void popFolder() {
        this.myContext.getLoader().popTemplateFolder();
    }

    @NotNull
    private File getTargetFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getTargetFile"));
        }
        if (file.isAbsolute()) {
            File file2 = file;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getTargetFile"));
            }
            return file2;
        }
        File file3 = new File(this.myContext.getOutputRoot(), file.getPath());
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getTargetFile"));
        }
        return file3;
    }

    private void mergeDependenciesIntoGradle() throws Exception {
        File gradleBuildFile = GradleUtil.getGradleBuildFilePath(this.myContext.getModuleRoot());
        String destinationContents = gradleBuildFile.exists() ? Strings.nullToEmpty((String)this.readTextFile(gradleBuildFile)) : "";
        Object buildApi = this.getParamMap().get("buildApi");
        String supportLibVersionFilter = buildApi != null ? buildApi.toString() : "";
        String result = this.myIO.mergeGradleFiles(this.formatDependencies(), destinationContents, this.myContext.getProject(), supportLibVersionFilter);
        this.myIO.writeFile(this, result, gradleBuildFile);
        this.myNeedsGradleSync = true;
    }

    private String formatDependencies() {
        StringBuilder dependencies = new StringBuilder();
        dependencies.append("dependencies {\n");
        for (Map.Entry dependency : this.myContext.getDependencies().entries()) {
            dependencies.append("  ").append((String)dependency.getKey()).append(" '").append((String)dependency.getValue()).append("'\n");
        }
        dependencies.append("}\n");
        return dependencies.toString();
    }

    private void copyDirectory(final @NotNull VirtualFile src, final @NotNull File dest) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copyDirectory"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copyDirectory"));
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$1", "visitFile"));
                }
                try {
                    return DefaultRecipeExecutor.this.copyFile(file, src, dest);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }, IOException.class);
    }

    private void copyTemplateResource(@NotNull File from, @NotNull File to) throws IOException {
        File destPath;
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copyTemplateResource"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copyTemplateResource"));
        }
        File source = this.myContext.getLoader().getSourceFile(from);
        File target = this.getTargetFile(to);
        VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)source, (boolean)true);
        assert (sourceFile != null) : source;
        sourceFile.refresh(false, false);
        File file = destPath = source.isDirectory() ? target : target.getParentFile();
        if (source.isDirectory()) {
            this.copyDirectory(sourceFile, destPath);
        } else if (target.exists()) {
            if (!this.compareFile(sourceFile, target)) {
                this.addFileAlreadyExistWarning(target);
            }
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(sourceFile);
            if (document != null) {
                this.myIO.writeFile(this, document.getText(), target);
            } else {
                this.myIO.copyFile(this, sourceFile, destPath, target.getName());
            }
            this.myReferences.addSourceFile(source);
            this.myReferences.addTargetFile(target);
        }
    }

    private boolean copyFile(VirtualFile file, VirtualFile src, File destinationFile) throws IOException {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)src, (char)File.separatorChar);
        if (relativePath == null) {
            throw new RuntimeException(String.format("%1$s is not a child of %2$s", file.getPath(), src));
        }
        if (file.isDirectory()) {
            this.myIO.mkDir(new File(destinationFile, relativePath));
        } else {
            File target = new File(destinationFile, relativePath);
            if (target.exists()) {
                if (!this.compareFile(file, target)) {
                    this.addFileAlreadyExistWarning(target);
                }
            } else {
                this.myIO.copyFile(this, file, target);
                this.myReferences.addSourceFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                this.myReferences.addTargetFile(target);
            }
        }
        return true;
    }

    private String readTextFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "readTextFile"));
        }
        if (Boolean.TRUE.equals(this.myContext.getParamMap().get("isNewProject"))) {
            return TemplateUtils.readTextFromDisk(file);
        }
        return TemplateUtils.readTextFromDocument(this.myContext.getProject(), file);
    }

    private String readTextFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "readTextFile"));
        }
        if (Boolean.TRUE.equals(this.myContext.getParamMap().get("isNewProject"))) {
            return TemplateUtils.readTextFromDisk(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        }
        return TemplateUtils.readTextFromDocument(this.myContext.getProject(), file);
    }

    public boolean compareFile(@NotNull VirtualFile sourceVFile, @NotNull File targetFile) throws IOException {
        if (sourceVFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceVFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "compareFile"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "compareFile"));
        }
        VirtualFile targetVFile = VfsUtil.findFileByIoFile((File)targetFile, (boolean)true);
        if (targetVFile == null) {
            return false;
        }
        if (sourceVFile.getFileType().isBinary()) {
            byte[] source = sourceVFile.contentsToByteArray();
            byte[] target = targetVFile.contentsToByteArray();
            return Arrays.equals(source, target);
        }
        String source = this.readTextFile(sourceVFile);
        String target = this.readTextFile(targetVFile);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        return comparisonManager.isEquals((CharSequence)source, (CharSequence)target, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    public boolean compareTextFile(@NotNull File targetFile, @NotNull String content) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "compareTextFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "compareTextFile"));
        }
        String target = this.readTextFile(targetFile);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        return comparisonManager.isEquals((CharSequence)content, (CharSequence)target, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    private void addFileAlreadyExistWarning(@NotNull File targetFile) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "addFileAlreadyExistWarning"));
        }
        this.addWarning(String.format("The following file could not be created since it already exists: %1$s", targetFile.getName()));
    }

    private static class DryRunRecipeIO
    extends RecipeIO {
        private DryRunRecipeIO() {
        }

        @Override
        public void writeFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "writeFile"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "writeFile"));
            }
            TemplateUtils.checkDirectoryIsWriteable(to.getParentFile());
        }

        @Override
        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFile) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "copyFile"));
            }
            if (toFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "copyFile"));
            }
            TemplateUtils.checkDirectoryIsWriteable(toFile.getParentFile());
        }

        @Override
        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFileDir, @Nullable String newName) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "copyFile"));
            }
            if (toFileDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFileDir", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "copyFile"));
            }
            TemplateUtils.checkDirectoryIsWriteable(toFileDir);
        }

        @Override
        public void mkDir(@NotNull File directory) throws IOException {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "mkDir"));
            }
            TemplateUtils.checkDirectoryIsWriteable(directory);
        }

        @Override
        public void applyChanges(@NotNull GradleBuildModel buildModel) {
            if (buildModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "applyChanges"));
            }
        }

        @Override
        public String mergeGradleFiles(@NotNull String dependencies, @NotNull String destinationContents, Project project, String compileSdkVersion) {
            if (dependencies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "mergeGradleFiles"));
            }
            if (destinationContents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destinationContents", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "mergeGradleFiles"));
            }
            return destinationContents;
        }

        @Override
        public void requestGradleSync(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "requestGradleSync"));
            }
        }
    }

    private static class RecipeIO {
        private RecipeIO() {
        }

        public void writeFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "writeFile"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "writeFile"));
            }
            TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            TemplateUtils.writeTextFile(this, contents, to);
        }

        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFile) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "copyFile"));
            }
            if (toFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "copyFile"));
            }
            VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(toFile.getParentFile());
            VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)toDir);
        }

        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFileDir, @NotNull String newName) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "copyFile"));
            }
            if (toFileDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFileDir", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "copyFile"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "copyFile"));
            }
            VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(toFileDir);
            VfsUtilCore.copyFile((Object)requestor, (VirtualFile)file, (VirtualFile)toDir, (String)newName);
        }

        public void mkDir(@NotNull File directory) throws IOException {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "mkDir"));
            }
            TemplateUtils.checkedCreateDirectoryIfMissing(directory);
        }

        public void applyChanges(@NotNull GradleBuildModel buildModel) {
            if (buildModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "applyChanges"));
            }
            buildModel.applyChanges();
        }

        public String mergeGradleFiles(@NotNull String dependencies, @NotNull String destinationContents, Project project, @Nullable String supportLibVersionFilter) {
            if (dependencies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "mergeGradleFiles"));
            }
            if (destinationContents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destinationContents", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "mergeGradleFiles"));
            }
            if (project.isInitialized()) {
                return GradleFilePsiMerger.mergeGradleFiles(dependencies, destinationContents, project, supportLibVersionFilter);
            }
            return GradleFileSimpleMerger.mergeGradleFiles(dependencies, destinationContents, project, supportLibVersionFilter);
        }

        public void requestGradleSync(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "requestGradleSync"));
            }
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "lambda$requestGradleSync$0"));
                }
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
            });
        }
    }
}

