/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.swing;

import com.android.tools.adtui.LabelWithEditLink;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.ui.EditorComboBox;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class TextProperty
extends StringProperty
implements DocumentListener,
PropertyChangeListener,
com.intellij.openapi.editor.event.DocumentListener {
    @NotNull
    private final JComponent myComponent;

    public TextProperty(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textComponent", "com/android/tools/idea/ui/properties/swing/TextProperty", "<init>"));
        }
        this.myComponent = textComponent;
        textComponent.getDocument().addDocumentListener(this);
    }

    public TextProperty(@NotNull AbstractButton button) {
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/android/tools/idea/ui/properties/swing/TextProperty", "<init>"));
        }
        this.myComponent = button;
        button.addPropertyChangeListener("text", this);
    }

    public TextProperty(@NotNull JLabel label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/ui/properties/swing/TextProperty", "<init>"));
        }
        this.myComponent = label;
        label.addPropertyChangeListener("text", this);
    }

    public TextProperty(@NotNull LabelWithEditLink editLabel) {
        if (editLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editLabel", "com/android/tools/idea/ui/properties/swing/TextProperty", "<init>"));
        }
        this.myComponent = editLabel;
        editLabel.getDocument().addDocumentListener(this);
    }

    public TextProperty(@NotNull EditorComboBox editorComboBox) {
        if (editorComboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorComboBox", "com/android/tools/idea/ui/properties/swing/TextProperty", "<init>"));
        }
        this.myComponent = editorComboBox;
        editorComboBox.getDocument().addDocumentListener((com.intellij.openapi.editor.event.DocumentListener)this);
    }

    @Override
    public void insertUpdate(javax.swing.event.DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void removeUpdate(javax.swing.event.DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void changedUpdate(javax.swing.event.DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyInvalidated();
    }

    public void documentChanged(DocumentEvent event) {
        this.notifyInvalidated();
    }

    @Override
    @NotNull
    public String get() {
        if (this.myComponent instanceof JTextComponent) {
            String string = ((JTextComponent)this.myComponent).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/TextProperty", "get"));
            }
            return string;
        }
        if (this.myComponent instanceof AbstractButton) {
            String string = ((AbstractButton)this.myComponent).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/TextProperty", "get"));
            }
            return string;
        }
        if (this.myComponent instanceof JLabel) {
            String string = ((JLabel)this.myComponent).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/TextProperty", "get"));
            }
            return string;
        }
        if (this.myComponent instanceof LabelWithEditLink) {
            String string = ((LabelWithEditLink)this.myComponent).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/TextProperty", "get"));
            }
            return string;
        }
        if (this.myComponent instanceof EditorComboBox) {
            String string = ((EditorComboBox)this.myComponent).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/TextProperty", "get"));
            }
            return string;
        }
        throw new IllegalStateException("Unexpected text component type: " + this.myComponent.getClass().getSimpleName());
    }

    @Override
    protected void setDirectly(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/swing/TextProperty", "setDirectly"));
        }
        if (this.myComponent instanceof JTextComponent) {
            ((JTextComponent)this.myComponent).setText(value);
        } else if (this.myComponent instanceof AbstractButton) {
            ((AbstractButton)this.myComponent).setText(value);
        } else if (this.myComponent instanceof JLabel) {
            ((JLabel)this.myComponent).setText(value);
        } else if (this.myComponent instanceof LabelWithEditLink) {
            ((LabelWithEditLink)this.myComponent).setText(value);
        } else if (this.myComponent instanceof EditorComboBox) {
            ((EditorComboBox)this.myComponent).setText(value);
        } else {
            throw new IllegalStateException("Unexpected text component type: " + this.myComponent.getClass().getSimpleName());
        }
    }
}

